/*!
 * jQuery UI Slider @VERSION
 *
 * Copyright 2012, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Slider
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
!function(e,i){
// number of pages in a slider
// (how many times can you page up/down to go through the whole range)
var t=5;e.widget("ui.slider",e.ui.mouse,{widgetEventPrefix:"slide",options:{animate:!1,distance:0,max:100,min:0,orientation:"horizontal",range:!1,step:1,value:0,values:null},_create:function(){var i=this,s=this.options,a=this.element.find(".ui-slider-handle").addClass("ui-state-default ui-corner-all"),n="<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",l=s.values&&s.values.length||1,h=[];this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this.element.addClass("ui-slider ui-slider-"+this.orientation+" ui-widget ui-widget-content ui-corner-all"+(s.disabled?" ui-slider-disabled ui-disabled":"")),this.range=e([]),s.range&&(s.range===!0&&(s.values||(s.values=[this._valueMin(),this._valueMin()]),s.values.length&&2!==s.values.length&&(s.values=[s.values[0],s.values[0]])),this.range=e("<div></div>").appendTo(this.element).addClass("ui-slider-range ui-widget-header"+("min"===s.range||"max"===s.range?" ui-slider-range-"+s.range:"")));for(var u=a.length;u<l;u+=1)h.push(n);this.handles=a.add(e(h.join("")).appendTo(i.element)),this.handle=this.handles.eq(0),this.handles.add(this.range).filter("a").click(function(e){e.preventDefault()}).hover(function(){s.disabled||e(this).addClass("ui-state-hover")},function(){e(this).removeClass("ui-state-hover")}).focus(function(){s.disabled?e(this).blur():(e(".ui-slider .ui-state-focus").removeClass("ui-state-focus"),e(this).addClass("ui-state-focus"))}).blur(function(){e(this).removeClass("ui-state-focus")}),this.handles.each(function(i){e(this).data("index.ui-slider-handle",i)}),this.handles.keydown(function(s){var a,n,l,h,u=e(this).data("index.ui-slider-handle");if(!i.options.disabled){switch(s.keyCode){case e.ui.keyCode.HOME:case e.ui.keyCode.END:case e.ui.keyCode.PAGE_UP:case e.ui.keyCode.PAGE_DOWN:case e.ui.keyCode.UP:case e.ui.keyCode.RIGHT:case e.ui.keyCode.DOWN:case e.ui.keyCode.LEFT:if(s.preventDefault(),!i._keySliding&&(i._keySliding=!0,e(this).addClass("ui-state-active"),a=i._start(s,u),a===!1))return}switch(h=i.options.step,n=l=i.options.values&&i.options.values.length?i.values(u):i.value(),s.keyCode){case e.ui.keyCode.HOME:l=i._valueMin();break;case e.ui.keyCode.END:l=i._valueMax();break;case e.ui.keyCode.PAGE_UP:l=i._trimAlignValue(n+(i._valueMax()-i._valueMin())/t);break;case e.ui.keyCode.PAGE_DOWN:l=i._trimAlignValue(n-(i._valueMax()-i._valueMin())/t);break;case e.ui.keyCode.UP:case e.ui.keyCode.RIGHT:if(n===i._valueMax())return;l=i._trimAlignValue(n+h);break;case e.ui.keyCode.DOWN:case e.ui.keyCode.LEFT:if(n===i._valueMin())return;l=i._trimAlignValue(n-h)}i._slide(s,u,l)}}).keyup(function(t){var s=e(this).data("index.ui-slider-handle");i._keySliding&&(i._keySliding=!1,i._stop(t,s),i._change(t,s),e(this).removeClass("ui-state-active"))}),this._refreshValue(),this._animateOff=!1},destroy:function(){return this.handles.remove(),this.range.remove(),this.element.removeClass("ui-slider ui-slider-horizontal ui-slider-vertical ui-slider-disabled ui-widget ui-widget-content ui-corner-all").removeData("slider").unbind(".slider"),this._mouseDestroy(),this},_mouseCapture:function(i){var t,s,a,n,l,h,u,o,r,d=this.options;
// workaround for bug #3736 (if both handles of a range are at 0,
// the first is always used as the one with least distance,
// and moving it is obviously prevented by preventing negative ranges)
return!d.disabled&&(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),t={x:i.pageX,y:i.pageY},s=this._normValueFromMouse(t),a=this._valueMax()-this._valueMin()+1,l=this,this.handles.each(function(i){var t=Math.abs(s-l.values(i));a>t&&(a=t,n=e(this),h=i)}),d.range===!0&&this.values(1)===d.min&&(h+=1,n=e(this.handles[h])),u=this._start(i,h),u!==!1&&(this._mouseSliding=!0,l._handleIndex=h,n.addClass("ui-state-active").focus(),o=n.offset(),r=!e(i.target).parents().andSelf().is(".ui-slider-handle"),this._clickOffset=r?{left:0,top:0}:{left:i.pageX-o.left-n.width()/2,top:i.pageY-o.top-n.height()/2-(parseInt(n.css("borderTopWidth"),10)||0)-(parseInt(n.css("borderBottomWidth"),10)||0)+(parseInt(n.css("marginTop"),10)||0)},this.handles.hasClass("ui-state-hover")||this._slide(i,h,s),this._animateOff=!0,!0))},_mouseStart:function(e){return!0},_mouseDrag:function(e){var i={x:e.pageX,y:e.pageY},t=this._normValueFromMouse(i);return this._slide(e,this._handleIndex,t),!1},_mouseStop:function(e){return this.handles.removeClass("ui-state-active"),this._mouseSliding=!1,this._stop(e,this._handleIndex),this._change(e,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1,!1},_detectOrientation:function(){this.orientation="vertical"===this.options.orientation?"vertical":"horizontal"},_normValueFromMouse:function(e){var i,t,s,a,n;return"horizontal"===this.orientation?(i=this.elementSize.width,t=e.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(i=this.elementSize.height,t=e.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),s=t/i,s>1&&(s=1),s<0&&(s=0),"vertical"===this.orientation&&(s=1-s),a=this._valueMax()-this._valueMin(),n=this._valueMin()+s*a,this._trimAlignValue(n)},_start:function(e,i){var t={handle:this.handles[i],value:this.value()};return this.options.values&&this.options.values.length&&(t.value=this.values(i),t.values=this.values()),this._trigger("start",e,t)},_slide:function(e,i,t){var s,a,n;this.options.values&&this.options.values.length?(s=this.values(i?0:1),2===this.options.values.length&&this.options.range===!0&&(0===i&&t>s||1===i&&t<s)&&(t=s),t!==this.values(i)&&(a=this.values(),a[i]=t,
// A slide can be canceled by returning false from the slide callback
n=this._trigger("slide",e,{handle:this.handles[i],value:t,values:a}),s=this.values(i?0:1),n!==!1&&this.values(i,t,!0))):t!==this.value()&&(
// A slide can be canceled by returning false from the slide callback
n=this._trigger("slide",e,{handle:this.handles[i],value:t}),n!==!1&&this.value(t))},_stop:function(e,i){var t={handle:this.handles[i],value:this.value()};this.options.values&&this.options.values.length&&(t.value=this.values(i),t.values=this.values()),this._trigger("stop",e,t)},_change:function(e,i){if(!this._keySliding&&!this._mouseSliding){var t={handle:this.handles[i],value:this.value()};this.options.values&&this.options.values.length&&(t.value=this.values(i),t.values=this.values()),this._trigger("change",e,t)}},value:function(e){return arguments.length?(this.options.value=this._trimAlignValue(e),this._refreshValue(),void this._change(null,0)):this._value()},values:function(i,t){var s,a,n;if(arguments.length>1)return this.options.values[i]=this._trimAlignValue(t),this._refreshValue(),void this._change(null,i);if(!arguments.length)return this._values();if(!e.isArray(arguments[0]))return this.options.values&&this.options.values.length?this._values(i):this.value();for(s=this.options.values,a=arguments[0],n=0;n<s.length;n+=1)s[n]=this._trimAlignValue(a[n]),this._change(null,n);this._refreshValue()},_setOption:function(i,t){var s,a=0;switch(e.isArray(this.options.values)&&(a=this.options.values.length),e.Widget.prototype._setOption.apply(this,arguments),i){case"disabled":t?(this.handles.filter(".ui-state-focus").blur(),this.handles.removeClass("ui-state-hover"),this.handles.propAttr("disabled",!0),this.element.addClass("ui-disabled")):(this.handles.propAttr("disabled",!1),this.element.removeClass("ui-disabled"));break;case"orientation":this._detectOrientation(),this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-"+this.orientation),this._refreshValue();break;case"value":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case"values":for(this._animateOff=!0,this._refreshValue(),s=0;s<a;s+=1)this._change(null,s);this._animateOff=!1}},
//internal value getter
// _value() returns value trimmed by min and max, aligned by step
_value:function(){var e=this.options.value;return e=this._trimAlignValue(e)},
//internal values getter
// _values() returns array of values trimmed by min and max, aligned by step
// _values( index ) returns single value trimmed by min and max, aligned by step
_values:function(e){var i,t,s;if(arguments.length)return i=this.options.values[e],i=this._trimAlignValue(i);for(
// .slice() creates a copy of the array
// this copy gets trimmed by min and max and then returned
t=this.options.values.slice(),s=0;s<t.length;s+=1)t[s]=this._trimAlignValue(t[s]);return t},
// returns the step-aligned value that val is closest to, between (inclusive) min and max
_trimAlignValue:function(e){if(e<=this._valueMin())return this._valueMin();if(e>=this._valueMax())return this._valueMax();var i=this.options.step>0?this.options.step:1,t=(e-this._valueMin())%i,s=e-t;
// Since JavaScript has problems with large floats, round
// the final value to 5 digits after the decimal point (see #4124)
return 2*Math.abs(t)>=i&&(s+=t>0?i:-i),parseFloat(s.toFixed(5))},_valueMin:function(){return this.options.min},_valueMax:function(){return this.options.max},_refreshValue:function(){var i,t,s,a,n,l=this.options.range,h=this.options,u=this,o=!this._animateOff&&h.animate,r={};this.options.values&&this.options.values.length?this.handles.each(function(s,a){i=(u.values(s)-u._valueMin())/(u._valueMax()-u._valueMin())*100,r["horizontal"===u.orientation?"left":"bottom"]=i+"%",e(this).stop(1,1)[o?"animate":"css"](r,h.animate),u.options.range===!0&&("horizontal"===u.orientation?(0===s&&u.range.stop(1,1)[o?"animate":"css"]({left:i+"%"},h.animate),1===s&&u.range[o?"animate":"css"]({width:i-t+"%"},{queue:!1,duration:h.animate})):(0===s&&u.range.stop(1,1)[o?"animate":"css"]({bottom:i+"%"},h.animate),1===s&&u.range[o?"animate":"css"]({height:i-t+"%"},{queue:!1,duration:h.animate}))),t=i}):(s=this.value(),a=this._valueMin(),n=this._valueMax(),i=n!==a?(s-a)/(n-a)*100:0,r["horizontal"===u.orientation?"left":"bottom"]=i+"%",this.handle.stop(1,1)[o?"animate":"css"](r,h.animate),"min"===l&&"horizontal"===this.orientation&&this.range.stop(1,1)[o?"animate":"css"]({width:i+"%"},h.animate),"max"===l&&"horizontal"===this.orientation&&this.range[o?"animate":"css"]({width:100-i+"%"},{queue:!1,duration:h.animate}),"min"===l&&"vertical"===this.orientation&&this.range.stop(1,1)[o?"animate":"css"]({height:i+"%"},h.animate),"max"===l&&"vertical"===this.orientation&&this.range[o?"animate":"css"]({height:100-i+"%"},{queue:!1,duration:h.animate}))}}),e.extend(e.ui.slider,{version:"@VERSION"})}(jQuery);