/*!
 * jQuery UI Resizable @VERSION
 *
 * Copyright 2012, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Resizables
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
!function(t,e){t.widget("ui.resizable",t.ui.mouse,{widgetEventPrefix:"resize",options:{alsoResize:!1,animate:!1,animateDuration:"slow",animateEasing:"swing",aspectRatio:!1,autoHide:!1,containment:!1,ghost:!1,grid:!1,handles:"e,s,se",helper:!1,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:1e3},_create:function(){var e=this,i=this.options;if(this.element.addClass("ui-resizable"),t.extend(this,{_aspectRatio:!!i.aspectRatio,aspectRatio:i.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:i.helper||i.ghost||i.animate?i.helper||"ui-resizable-helper":null}),
//Wrap the element if it cannot hold child nodes
this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)&&(
//Create a wrapper element and set the wrapper to the new current internal element
this.element.wrap(t('<div class="ui-wrapper" style="overflow: hidden;"></div>').css({position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")})),
//Overwrite the original this.element
this.element=this.element.parent().data("resizable",this.element.data("resizable")),this.elementIsWrapper=!0,
//Move margins to the wrapper
this.element.css({marginLeft:this.originalElement.css("marginLeft"),marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom")}),this.originalElement.css({marginLeft:0,marginTop:0,marginRight:0,marginBottom:0}),
//Prevent Safari textarea resize
this.originalResizeStyle=this.originalElement.css("resize"),this.originalElement.css("resize","none"),
//Push the actual element to our proportionallyResize internal array
this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"})),
// avoid IE jump (hard set the margin)
this.originalElement.css({margin:this.originalElement.css("margin")}),
// fix handlers offset
this._proportionallyResize()),this.handles=i.handles||(t(".ui-resizable-handle",this.element).length?{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"}:"e,s,se"),this.handles.constructor==String){"all"==this.handles&&(this.handles="n,e,s,w,se,sw,ne,nw");var s=this.handles.split(",");this.handles={};for(var h=0;h<s.length;h++){var n=t.trim(s[h]),o="ui-resizable-"+n,a=t('<div class="ui-resizable-handle '+o+'"></div>');
// Apply zIndex to all handles - see #7960
a.css({zIndex:i.zIndex}),
//TODO : What's going on here?
"se"==n&&a.addClass("ui-icon ui-icon-gripsmall-diagonal-se"),
//Insert into internal handles object and append to element
this.handles[n]=".ui-resizable-"+n,this.element.append(a)}}this._renderAxis=function(e){e=e||this.element;for(var i in this.handles){
//Apply pad to wrapper element, needed to fix axis position (textarea, inputs, scrolls)
if(this.handles[i].constructor==String&&(this.handles[i]=t(this.handles[i],this.element).show()),this.elementIsWrapper&&this.originalElement[0].nodeName.match(/textarea|input|select|button/i)){var s=t(this.handles[i],this.element),h=0;
//Checking the correct pad and border
h=/sw|ne|nw|se|n|s/.test(i)?s.outerHeight():s.outerWidth();
//The padding type i have to apply...
var n=["padding",/ne|nw|n/.test(i)?"Top":/se|sw|s/.test(i)?"Bottom":/^e$/.test(i)?"Right":"Left"].join("");e.css(n,h),this._proportionallyResize()}t(this.handles[i]).length}},
//TODO: make renderAxis a prototype function
this._renderAxis(this.element),this._handles=t(".ui-resizable-handle",this.element).disableSelection(),
//Matching axis name
this._handles.mouseover(function(){if(!e.resizing){if(this.className)var t=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i);
//Axis, default = se
e.axis=t&&t[1]?t[1]:"se"}}),
//If we want to auto hide the elements
i.autoHide&&(this._handles.hide(),t(this.element).addClass("ui-resizable-autohide").hover(function(){i.disabled||(t(this).removeClass("ui-resizable-autohide"),e._handles.show())},function(){i.disabled||e.resizing||(t(this).addClass("ui-resizable-autohide"),e._handles.hide())})),
//Initialize the mouse interaction
this._mouseInit()},destroy:function(){this._mouseDestroy();var e=function(e){t(e).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing").removeData("resizable").unbind(".resizable").find(".ui-resizable-handle").remove()};
//TODO: Unwrap at same DOM position
if(this.elementIsWrapper){e(this.element);var i=this.element;i.after(this.originalElement.css({position:i.css("position"),width:i.outerWidth(),height:i.outerHeight(),top:i.css("top"),left:i.css("left")})).remove()}return this.originalElement.css("resize",this.originalResizeStyle),e(this.originalElement),this},_mouseCapture:function(e){var i=!1;for(var s in this.handles)t(this.handles[s])[0]==e.target&&(i=!0);return!this.options.disabled&&i},_mouseStart:function(e){var s=this.options,h=this.element.position(),n=this.element;this.resizing=!0,this.documentScroll={top:t(document).scrollTop(),left:t(document).scrollLeft()},
// bugfix for http://dev.jquery.com/ticket/1749
(n.is(".ui-draggable")||/absolute/.test(n.css("position")))&&n.css({position:"absolute",top:h.top,left:h.left}),this._renderProxy();var o=i(this.helper.css("left")),a=i(this.helper.css("top"));s.containment&&(o+=t(s.containment).scrollLeft()||0,a+=t(s.containment).scrollTop()||0),
//Store needed variables
this.offset=this.helper.offset(),this.position={left:o,top:a},this.size=this._helper?{width:n.outerWidth(),height:n.outerHeight()}:{width:n.width(),height:n.height()},this.originalSize=this._helper?{width:n.outerWidth(),height:n.outerHeight()}:{width:n.width(),height:n.height()},this.originalPosition={left:o,top:a},this.sizeDiff={width:n.outerWidth()-n.width(),height:n.outerHeight()-n.height()},this.originalMousePosition={left:e.pageX,top:e.pageY},
//Aspect Ratio
this.aspectRatio="number"==typeof s.aspectRatio?s.aspectRatio:this.originalSize.width/this.originalSize.height||1;var r=t(".ui-resizable-"+this.axis).css("cursor");return t("body").css("cursor","auto"==r?this.axis+"-resize":r),n.addClass("ui-resizable-resizing"),this._propagate("start",e),!0},_mouseDrag:function(e){
//Increase performance, avoid regex
var i=this.helper,s=(this.options,this.originalMousePosition),h=this.axis,n=e.pageX-s.left||0,o=e.pageY-s.top||0,a=this._change[h];if(!a)return!1;
// Calculate the attrs that will be change
var r=a.apply(this,[e,n,o]);t.browser.msie&&t.browser.version<7,this.sizeDiff;
// Put this in the mouseDrag handler since the user can start pressing shift while resizing
// plugins callbacks need to be called first
// calling the user callback at the end
return this._updateVirtualBoundaries(e.shiftKey),(this._aspectRatio||e.shiftKey)&&(r=this._updateRatio(r,e)),r=this._respectSize(r,e),this._propagate("resize",e),i.css({top:this.position.top+"px",left:this.position.left+"px",width:this.size.width+"px",height:this.size.height+"px"}),!this._helper&&this._proportionallyResizeElements.length&&this._proportionallyResize(),this._updateCache(r),this._trigger("resize",e,this.ui()),!1},_mouseStop:function(e){this.resizing=!1;var i=this.options,s=this;if(this._helper){var h=this._proportionallyResizeElements,n=h.length&&/textarea/i.test(h[0].nodeName),o=n&&t.ui.hasScroll(h[0],"left")?0:s.sizeDiff.height,a=n?0:s.sizeDiff.width,r={width:s.helper.width()-a,height:s.helper.height()-o},l=parseInt(s.element.css("left"),10)+(s.position.left-s.originalPosition.left)||null,p=parseInt(s.element.css("top"),10)+(s.position.top-s.originalPosition.top)||null;i.animate||this.element.css(t.extend(r,{top:p,left:l})),s.helper.height(s.size.height),s.helper.width(s.size.width),this._helper&&!i.animate&&this._proportionallyResize()}return t("body").css("cursor","auto"),this.element.removeClass("ui-resizable-resizing"),this._propagate("stop",e),this._helper&&this.helper.remove(),!1},_updateVirtualBoundaries:function(t){var e,i,h,n,o,a=this.options;o={minWidth:s(a.minWidth)?a.minWidth:0,maxWidth:s(a.maxWidth)?a.maxWidth:1/0,minHeight:s(a.minHeight)?a.minHeight:0,maxHeight:s(a.maxHeight)?a.maxHeight:1/0},(this._aspectRatio||t)&&(
// We want to create an enclosing box whose aspect ration is the requested one
// First, compute the "projected" size for each dimension based on the aspect ratio and other dimension
e=o.minHeight*this.aspectRatio,h=o.minWidth/this.aspectRatio,i=o.maxHeight*this.aspectRatio,n=o.maxWidth/this.aspectRatio,e>o.minWidth&&(o.minWidth=e),h>o.minHeight&&(o.minHeight=h),i<o.maxWidth&&(o.maxWidth=i),n<o.maxHeight&&(o.maxHeight=n)),this._vBoundaries=o},_updateCache:function(t){this.options;this.offset=this.helper.offset(),s(t.left)&&(this.position.left=t.left),s(t.top)&&(this.position.top=t.top),s(t.height)&&(this.size.height=t.height),s(t.width)&&(this.size.width=t.width)},_updateRatio:function(t,e){var i=(this.options,this.position),h=this.size,n=this.axis;return s(t.height)?t.width=t.height*this.aspectRatio:s(t.width)&&(t.height=t.width/this.aspectRatio),"sw"==n&&(t.left=i.left+(h.width-t.width),t.top=null),"nw"==n&&(t.top=i.top+(h.height-t.height),t.left=i.left+(h.width-t.width)),t},_respectSize:function(t,e){var i=(this.helper,this._vBoundaries),h=(this._aspectRatio||e.shiftKey,this.axis),n=s(t.width)&&i.maxWidth&&i.maxWidth<t.width,o=s(t.height)&&i.maxHeight&&i.maxHeight<t.height,a=s(t.width)&&i.minWidth&&i.minWidth>t.width,r=s(t.height)&&i.minHeight&&i.minHeight>t.height;a&&(t.width=i.minWidth),r&&(t.height=i.minHeight),n&&(t.width=i.maxWidth),o&&(t.height=i.maxHeight);var l=this.originalPosition.left+this.originalSize.width,p=this.position.top+this.size.height,d=/sw|nw|w/.test(h),g=/nw|ne|n/.test(h);a&&d&&(t.left=l-i.minWidth),n&&d&&(t.left=l-i.maxWidth),r&&g&&(t.top=p-i.minHeight),o&&g&&(t.top=p-i.maxHeight);
// fixing jump error on top/left - bug #2330
var f=!t.width&&!t.height;return f&&!t.left&&t.top?t.top=null:f&&!t.top&&t.left&&(t.left=null),t},_proportionallyResize:function(){this.options;if(this._proportionallyResizeElements.length)for(var e=this.helper||this.element,i=0;i<this._proportionallyResizeElements.length;i++){var s=this._proportionallyResizeElements[i];if(!this.borderDif){var h=[s.css("borderTopWidth"),s.css("borderRightWidth"),s.css("borderBottomWidth"),s.css("borderLeftWidth")],n=[s.css("paddingTop"),s.css("paddingRight"),s.css("paddingBottom"),s.css("paddingLeft")];this.borderDif=t.map(h,function(t,e){var i=parseInt(t,10)||0,s=parseInt(n[e],10)||0;return i+s})}t.browser.msie&&(t(e).is(":hidden")||t(e).parents(":hidden").length)||s.css({height:e.height()-this.borderDif[0]-this.borderDif[2]||0,width:e.width()-this.borderDif[1]-this.borderDif[3]||0})}},_renderProxy:function(){var e=this.element,i=this.options;if(this.elementOffset=e.offset(),this._helper){this.helper=this.helper||t('<div style="overflow:hidden;"></div>');
// fix ie6 offset TODO: This seems broken
var s=t.browser.msie&&t.browser.version<7,h=s?1:0,n=s?2:-1;this.helper.addClass(this._helper).css({width:this.element.outerWidth()+n,height:this.element.outerHeight()+n,position:"absolute",left:this.elementOffset.left-h+"px",top:this.elementOffset.top-h+"px",zIndex:++i.zIndex}),this.helper.appendTo("body").disableSelection()}else this.helper=this.element},_change:{e:function(t,e,i){return{width:this.originalSize.width+e}},w:function(t,e,i){var s=(this.options,this.originalSize),h=this.originalPosition;return{left:h.left+e,width:s.width-e}},n:function(t,e,i){var s=(this.options,this.originalSize),h=this.originalPosition;return{top:h.top+i,height:s.height-i}},s:function(t,e,i){return{height:this.originalSize.height+i}},se:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},sw:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[e,i,s]))},ne:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},nw:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[e,i,s]))}},_propagate:function(e,i){t.ui.plugin.call(this,e,[i,this.ui()]),"resize"!=e&&this._trigger(e,i,this.ui())},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}}}),t.extend(t.ui.resizable,{version:"@VERSION"}),/*
 * Resizable Extensions
 */
t.ui.plugin.add("resizable","alsoResize",{start:function(e,i){var s=t(this).data("resizable"),h=s.options,n=function(e){t(e).each(function(){var e=t(this);e.data("resizable-alsoresize",{width:parseInt(e.width(),10),height:parseInt(e.height(),10),left:parseInt(e.css("left"),10),top:parseInt(e.css("top"),10)})})};"object"!=typeof h.alsoResize||h.alsoResize.parentNode?n(h.alsoResize):h.alsoResize.length?(h.alsoResize=h.alsoResize[0],n(h.alsoResize)):t.each(h.alsoResize,function(t){n(t)})},resize:function(e,i){var s=t(this).data("resizable"),h=s.options,n=s.originalSize,o=s.originalPosition,a={height:s.size.height-n.height||0,width:s.size.width-n.width||0,top:s.position.top-o.top||0,left:s.position.left-o.left||0},r=function(e,s){t(e).each(function(){var e=t(this),h=t(this).data("resizable-alsoresize"),n={},o=s&&s.length?s:e.parents(i.originalElement[0]).length?["width","height"]:["width","height","top","left"];t.each(o,function(t,e){var i=(h[e]||0)+(a[e]||0);i&&i>=0&&(n[e]=i||null)}),e.css(n)})};"object"!=typeof h.alsoResize||h.alsoResize.nodeType?r(h.alsoResize):t.each(h.alsoResize,function(t,e){r(t,e)})},stop:function(e,i){t(this).removeData("resizable-alsoresize")}}),t.ui.plugin.add("resizable","animate",{stop:function(e,i){var s=t(this).data("resizable"),h=s.options,n=s._proportionallyResizeElements,o=n.length&&/textarea/i.test(n[0].nodeName),a=o&&t.ui.hasScroll(n[0],"left")?0:s.sizeDiff.height,r=o?0:s.sizeDiff.width,l={width:s.size.width-r,height:s.size.height-a},p=parseInt(s.element.css("left"),10)+(s.position.left-s.originalPosition.left)||null,d=parseInt(s.element.css("top"),10)+(s.position.top-s.originalPosition.top)||null;s.element.animate(t.extend(l,d&&p?{top:d,left:p}:{}),{duration:h.animateDuration,easing:h.animateEasing,step:function(){var i={width:parseInt(s.element.css("width"),10),height:parseInt(s.element.css("height"),10),top:parseInt(s.element.css("top"),10),left:parseInt(s.element.css("left"),10)};n&&n.length&&t(n[0]).css({width:i.width,height:i.height}),
// propagating resize, and updating values for each animation step
s._updateCache(i),s._propagate("resize",e)}})}}),t.ui.plugin.add("resizable","containment",{start:function(e,s){var h=t(this).data("resizable"),n=h.options,o=h.element,a=n.containment,r=a instanceof t?a.get(0):/parent/.test(a)?o.parent().get(0):a;if(r)if(h.containerElement=t(r),/document/.test(a)||a==document)h.containerOffset={left:0,top:0},h.containerPosition={left:0,top:0},h.parentData={element:t(document),left:0,top:0,width:t(document).width(),height:t(document).height()||document.body.parentNode.scrollHeight};else{var l=t(r),p=[];t(["Top","Right","Left","Bottom"]).each(function(t,e){p[t]=i(l.css("padding"+e))}),h.containerOffset=l.offset(),h.containerPosition=l.position(),h.containerSize={height:l.innerHeight()-p[3],width:l.innerWidth()-p[1]};var d=h.containerOffset,g=h.containerSize.height,f=h.containerSize.width,c=t.ui.hasScroll(r,"left")?r.scrollWidth:f,u=t.ui.hasScroll(r)?r.scrollHeight:g;h.parentData={element:r,left:d.left,top:d.top,width:c,height:u}}},resize:function(e,i){var s=t(this).data("resizable"),h=s.options,n=(s.containerSize,s.containerOffset),o=(s.size,s.position),a=s._aspectRatio||e.shiftKey,r={top:0,left:0},l=s.containerElement;l[0]!=document&&/static/.test(l.css("position"))&&(r=n),o.left<(s._helper?n.left:0)&&(s.size.width=s.size.width+(s._helper?s.position.left-n.left:s.position.left-r.left),a&&(s.size.height=s.size.width/s.aspectRatio),s.position.left=h.helper?n.left:0),o.top<(s._helper?n.top:0)&&(s.size.height=s.size.height+(s._helper?s.position.top-n.top:s.position.top),a&&(s.size.width=s.size.height*s.aspectRatio),s.position.top=s._helper?n.top:0),s.offset.left=s.parentData.left+s.position.left,s.offset.top=s.parentData.top+s.position.top;var p=Math.abs((s._helper?s.offset.left-r.left:s.offset.left-r.left)+s.sizeDiff.width),d=Math.abs((s._helper?s.offset.top-r.top:s.offset.top-n.top)+s.sizeDiff.height),g=s.containerElement.get(0)==s.element.parent().get(0),f=/relative|absolute/.test(s.containerElement.css("position"));g&&f&&(p-=s.parentData.left),p+s.size.width>=s.parentData.width&&(s.size.width=s.parentData.width-p,a&&(s.size.height=s.size.width/s.aspectRatio)),d+s.size.height>=s.parentData.height&&(s.size.height=s.parentData.height-d,a&&(s.size.width=s.size.height*s.aspectRatio))},stop:function(e,i){var s=t(this).data("resizable"),h=s.options,n=(s.position,s.containerOffset),o=s.containerPosition,a=s.containerElement,r=t(s.helper),l=r.offset(),p=r.outerWidth()-s.sizeDiff.width,d=r.outerHeight()-s.sizeDiff.height;s._helper&&!h.animate&&/relative/.test(a.css("position"))&&t(this).css({left:l.left-o.left-n.left,width:p,height:d}),s._helper&&!h.animate&&/static/.test(a.css("position"))&&t(this).css({left:l.left-o.left-n.left,width:p,height:d})}}),t.ui.plugin.add("resizable","ghost",{start:function(e,i){var s=t(this).data("resizable"),h=s.options,n=s.size;s.ghost=s.originalElement.clone(),s.ghost.css({opacity:.25,display:"block",position:"relative",height:n.height,width:n.width,margin:0,left:0,top:0}).addClass("ui-resizable-ghost").addClass("string"==typeof h.ghost?h.ghost:""),s.ghost.appendTo(s.helper)},resize:function(e,i){var s=t(this).data("resizable");s.options;s.ghost&&s.ghost.css({position:"relative",height:s.size.height,width:s.size.width})},stop:function(e,i){var s=t(this).data("resizable");s.options;s.ghost&&s.helper&&s.helper.get(0).removeChild(s.ghost.get(0))}}),t.ui.plugin.add("resizable","grid",{resize:function(e,i){var s=t(this).data("resizable"),h=s.options,n=s.size,o=s.originalSize,a=s.originalPosition,r=s.axis;h._aspectRatio||e.shiftKey;h.grid="number"==typeof h.grid?[h.grid,h.grid]:h.grid;var l=Math.round((n.width-o.width)/(h.grid[0]||1))*(h.grid[0]||1),p=Math.round((n.height-o.height)/(h.grid[1]||1))*(h.grid[1]||1);/^(se|s|e)$/.test(r)?(s.size.width=o.width+l,s.size.height=o.height+p):/^(ne)$/.test(r)?(s.size.width=o.width+l,s.size.height=o.height+p,s.position.top=a.top-p):/^(sw)$/.test(r)?(s.size.width=o.width+l,s.size.height=o.height+p,s.position.left=a.left-l):(s.size.width=o.width+l,s.size.height=o.height+p,s.position.top=a.top-p,s.position.left=a.left-l)}});var i=function(t){return parseInt(t,10)||0},s=function(t){return!isNaN(parseInt(t,10))}}(jQuery);