/*!
 * jQuery UI Draggable @VERSION
 *
 * Copyright 2012, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Draggables
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
!function(t,e){t.widget("ui.draggable",t.ui.mouse,{widgetEventPrefix:"drag",options:{addClasses:!0,appendTo:"parent",axis:!1,connectToSortable:!1,containment:!1,cursor:"auto",cursorAt:!1,grid:!1,handle:!1,helper:"original",iframeFix:!1,opacity:!1,refreshPositions:!1,revert:!1,revertDuration:500,scope:"default",scroll:!0,scrollSensitivity:20,scrollSpeed:20,snap:!1,snapMode:"both",snapTolerance:20,stack:!1,zIndex:!1},_create:function(){"original"!=this.options.helper||/^(?:r|a|f)/.test(this.element.css("position"))||(this.element[0].style.position="relative"),this.options.addClasses&&this.element.addClass("ui-draggable"),this.options.disabled&&this.element.addClass("ui-draggable-disabled"),this._mouseInit()},destroy:function(){if(this.element.data("draggable"))return this.element.removeData("draggable").unbind(".draggable").removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled"),this._mouseDestroy(),this},_mouseCapture:function(e){var s=this.options;
// among others, prevent a drag on a resizable-handle
// among others, prevent a drag on a resizable-handle
//Quit if we're not on a valid handle
return!(this.helper||s.disabled||t(e.target).is(".ui-resizable-handle"))&&(this.handle=this._getHandle(e),!!this.handle&&(s.iframeFix&&t(s.iframeFix===!0?"iframe":s.iframeFix).each(function(){t('<div class="ui-draggable-iframeFix" style="background: #fff;"></div>').css({width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1e3}).css(t(this).offset()).appendTo("body")}),!0))},_mouseStart:function(e){var s=this.options;
//Trigger event + callbacks
//Create and append the visible helper
//Cache the helper size
//If ddmanager is used for droppables, set the global draggable
/*
		 * - Position generation -
		 * This block generates everything position related - it's the core of draggables.
		 */
//Cache the margins of the original element
//Store the helper's css position
//The element's absolute position on the page minus margins
//Generate the original position
//Adjust the mouse offset relative to the helper if 'cursorAt' is supplied
//Set a containment if given in the options
//Trigger event + callbacks
//Recache the helper size
//Prepare the droppable offsets
//Execute the drag once - this causes the helper not to be visible before getting its correct position
//If the ddmanager is used for droppables, inform the manager that dragging has started (see #5003)
return this.helper=this._createHelper(e),this._cacheHelperProportions(),t.ui.ddmanager&&(t.ui.ddmanager.current=this),this._cacheMargins(),this.cssPosition=this.helper.css("position"),this.scrollParent=this.helper.scrollParent(),this.offset=this.positionAbs=this.element.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},t.extend(this.offset,{click:{//Where the click happened, relative to the element
left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.originalPosition=this.position=this._generatePosition(e),this.originalPageX=e.pageX,this.originalPageY=e.pageY,s.cursorAt&&this._adjustOffsetFromHelper(s.cursorAt),s.containment&&this._setContainment(),this._trigger("start",e)===!1?(this._clear(),!1):(this._cacheHelperProportions(),t.ui.ddmanager&&!s.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this.helper.addClass("ui-draggable-dragging"),this._mouseDrag(e,!0),t.ui.ddmanager&&t.ui.ddmanager.dragStart(this,e),!0)},_mouseDrag:function(e,s){
//Call plugins and callbacks and use the resulting position if something is returned
if(
//Compute the helpers position
this.position=this._generatePosition(e),this.positionAbs=this._convertPositionTo("absolute"),!s){var i=this._uiHash();if(this._trigger("drag",e,i)===!1)return this._mouseUp({}),!1;this.position=i.position}return this.options.axis&&"y"==this.options.axis||(this.helper[0].style.left=this.position.left+"px"),this.options.axis&&"x"==this.options.axis||(this.helper[0].style.top=this.position.top+"px"),t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),!1},_mouseStop:function(e){
//If we are using droppables, inform the manager about the drop
var s=!1;t.ui.ddmanager&&!this.options.dropBehaviour&&(s=t.ui.ddmanager.drop(this,e)),
//if a drop comes from outside (a sortable)
this.dropped&&(s=this.dropped,this.dropped=!1);for(
//if the original element is no longer in the DOM don't bother to continue (see #8269)
var i=this.element[0],o=!1;i&&(i=i.parentNode);)i==document&&(o=!0);if(!o&&"original"===this.options.helper)return!1;if("invalid"==this.options.revert&&!s||"valid"==this.options.revert&&s||this.options.revert===!0||t.isFunction(this.options.revert)&&this.options.revert.call(this.element,s)){var n=this;t(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){n._trigger("stop",e)!==!1&&n._clear()})}else this._trigger("stop",e)!==!1&&this._clear();return!1},_mouseUp:function(e){
//If the ddmanager is used for droppables, inform the manager that dragging has stopped (see #5003)
return this.options.iframeFix===!0&&t("div.ui-draggable-iframeFix").each(function(){this.parentNode.removeChild(this)}),t.ui.ddmanager&&t.ui.ddmanager.dragStop(this,e),t.ui.mouse.prototype._mouseUp.call(this,e)},cancel:function(){return this.helper.is(".ui-draggable-dragging")?this._mouseUp({}):this._clear(),this},_getHandle:function(e){var s=!this.options.handle||!t(this.options.handle,this.element).length;return t(this.options.handle,this.element).find("*").andSelf().each(function(){this==e.target&&(s=!0)}),s},_createHelper:function(e){var s=this.options,i=t.isFunction(s.helper)?t(s.helper.apply(this.element[0],[e])):"clone"==s.helper?this.element.clone().removeAttr("id"):this.element;return i.parents("body").length||i.appendTo("parent"==s.appendTo?this.element[0].parentNode:s.appendTo),i[0]==this.element[0]||/(fixed|absolute)/.test(i.css("position"))||i.css("position","absolute"),i},_adjustOffsetFromHelper:function(e){"string"==typeof e&&(e=e.split(" ")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),"left"in e&&(this.offset.click.left=e.left+this.margins.left),"right"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),"top"in e&&(this.offset.click.top=e.top+this.margins.top),"bottom"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_getParentOffset:function(){
//Get the offsetParent and cache its position
this.offsetParent=this.helper.offsetParent();var e=this.offsetParent.offset();
// This is a special case where we need to modify a offset calculated on start, since the following happened:
// 1. The position of the helper is absolute, so it's position is calculated based on the next positioned parent
// 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't the document, which means that
//    the scroll is included in the initial calculation of the offset of the parent, and never recalculated upon drag
//Ugly IE fix
return"absolute"==this.cssPosition&&this.scrollParent[0]!=document&&t.ui.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]==document.body||this.offsetParent[0].tagName&&"html"==this.offsetParent[0].tagName.toLowerCase()&&t.browser.msie)&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"==this.cssPosition){var t=this.element.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e=this.options;if("parent"==e.containment&&(e.containment=this.helper[0].parentNode),"document"!=e.containment&&"window"!=e.containment||(this.containment=["document"==e.containment?0:t(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,"document"==e.containment?0:t(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,("document"==e.containment?0:t(window).scrollLeft())+t("document"==e.containment?document:window).width()-this.helperProportions.width-this.margins.left,("document"==e.containment?0:t(window).scrollTop())+(t("document"==e.containment?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(e.containment)||e.containment.constructor==Array)e.containment.constructor==Array&&(this.containment=e.containment);else{var s=t(e.containment),i=s[0];if(!i)return;var o=(s.offset(),"hidden"!=t(i).css("overflow"));this.containment=[(parseInt(t(i).css("borderLeftWidth"),10)||0)+(parseInt(t(i).css("paddingLeft"),10)||0),(parseInt(t(i).css("borderTopWidth"),10)||0)+(parseInt(t(i).css("paddingTop"),10)||0),(o?Math.max(i.scrollWidth,i.offsetWidth):i.offsetWidth)-(parseInt(t(i).css("borderLeftWidth"),10)||0)-(parseInt(t(i).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(o?Math.max(i.scrollHeight,i.offsetHeight):i.offsetHeight)-(parseInt(t(i).css("borderTopWidth"),10)||0)-(parseInt(t(i).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom],this.relative_container=s}},_convertPositionTo:function(e,s){s||(s=this.position);var i="absolute"==e?1:-1,o=(this.options,"absolute"!=this.cssPosition||this.scrollParent[0]!=document&&t.ui.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent),n=/(html|body)/i.test(o[0].tagName);return{top:s.top+this.offset.relative.top*i+this.offset.parent.top*i-(t.browser.safari&&t.browser.version<526&&"fixed"==this.cssPosition?0:("fixed"==this.cssPosition?-this.scrollParent.scrollTop():n?0:o.scrollTop())*i),left:s.left+this.offset.relative.left*i+this.offset.parent.left*i-(t.browser.safari&&t.browser.version<526&&"fixed"==this.cssPosition?0:("fixed"==this.cssPosition?-this.scrollParent.scrollLeft():n?0:o.scrollLeft())*i)}},_generatePosition:function(e){var s=this.options,i="absolute"!=this.cssPosition||this.scrollParent[0]!=document&&t.ui.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,o=/(html|body)/i.test(i[0].tagName),n=e.pageX,r=e.pageY;/*
		 * - Position constraining -
		 * Constrain the position to a mix of grid, containment.
		 */
if(this.originalPosition){//If we are not dragging yet, we won't check for options
var a;if(this.containment){if(this.relative_container){var l=this.relative_container.offset();a=[this.containment[0]+l.left,this.containment[1]+l.top,this.containment[2]+l.left,this.containment[3]+l.top]}else a=this.containment;e.pageX-this.offset.click.left<a[0]&&(n=a[0]+this.offset.click.left),e.pageY-this.offset.click.top<a[1]&&(r=a[1]+this.offset.click.top),e.pageX-this.offset.click.left>a[2]&&(n=a[2]+this.offset.click.left),e.pageY-this.offset.click.top>a[3]&&(r=a[3]+this.offset.click.top)}if(s.grid){
//Check for grid elements set to 0 to prevent divide by 0 error causing invalid argument errors in IE (see ticket #6950)
var h=s.grid[1]?this.originalPageY+Math.round((r-this.originalPageY)/s.grid[1])*s.grid[1]:this.originalPageY;r=a&&(h-this.offset.click.top<a[1]||h-this.offset.click.top>a[3])?h-this.offset.click.top<a[1]?h+s.grid[1]:h-s.grid[1]:h;var c=s.grid[0]?this.originalPageX+Math.round((n-this.originalPageX)/s.grid[0])*s.grid[0]:this.originalPageX;n=a&&(c-this.offset.click.left<a[0]||c-this.offset.click.left>a[2])?c-this.offset.click.left<a[0]?c+s.grid[0]:c-s.grid[0]:c}}return{top:r-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(t.browser.safari&&t.browser.version<526&&"fixed"==this.cssPosition?0:"fixed"==this.cssPosition?-this.scrollParent.scrollTop():o?0:i.scrollTop()),left:n-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(t.browser.safari&&t.browser.version<526&&"fixed"==this.cssPosition?0:"fixed"==this.cssPosition?-this.scrollParent.scrollLeft():o?0:i.scrollLeft())}},_clear:function(){this.helper.removeClass("ui-draggable-dragging"),this.helper[0]==this.element[0]||this.cancelHelperRemoval||this.helper.remove(),
//if($.ui.ddmanager) $.ui.ddmanager.current = null;
this.helper=null,this.cancelHelperRemoval=!1},
// From now on bulk stuff - mainly helpers
_trigger:function(e,s,i){//The absolute position has to be recalculated after plugins
return i=i||this._uiHash(),t.ui.plugin.call(this,e,[s,i]),"drag"==e&&(this.positionAbs=this._convertPositionTo("absolute")),t.Widget.prototype._trigger.call(this,e,s,i)},plugins:{},_uiHash:function(t){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}}),t.extend(t.ui.draggable,{version:"@VERSION"}),t.ui.plugin.add("draggable","connectToSortable",{start:function(e,s){var i=t(this).data("draggable"),o=i.options,n=t.extend({},s,{item:i.element});i.sortables=[],t(o.connectToSortable).each(function(){var s=t.data(this,"sortable");s&&!s.options.disabled&&(i.sortables.push({instance:s,shouldRevert:s.options.revert}),s.refreshPositions(),// Call the sortable's refreshPositions at drag start to refresh the containerCache since the sortable container cache is used in drag and needs to be up to date (this will ensure it's initialised as well as being kept in step with any changes that might have happened on the page).
s._trigger("activate",e,n))})},stop:function(e,s){
//If we are still over the sortable, we fake the stop event of the sortable, but also remove helper
var i=t(this).data("draggable"),o=t.extend({},s,{item:i.element});t.each(i.sortables,function(){this.instance.isOver?(this.instance.isOver=0,i.cancelHelperRemoval=!0,//Don't remove the helper in the draggable instance
this.instance.cancelHelperRemoval=!1,//Remove it in the sortable instance (so sortable plugins like revert still work)
//The sortable revert is supported, and we have to set a temporary dropped variable on the draggable to support revert: 'valid/invalid'
this.shouldRevert&&(this.instance.options.revert=!0),
//Trigger the stop of the sortable
this.instance._mouseStop(e),this.instance.options.helper=this.instance.options._helper,
//If the helper has been the original item, restore properties in the sortable
"original"==i.options.helper&&this.instance.currentItem.css({top:"auto",left:"auto"})):(this.instance.cancelHelperRemoval=!1,//Remove the helper in the sortable instance
this.instance._trigger("deactivate",e,o))})},drag:function(e,s){var i=t(this).data("draggable"),o=this;t.each(i.sortables,function(n){
//Copy over some variables to allow calling the sortable's native _intersectsWith
this.instance.positionAbs=i.positionAbs,this.instance.helperProportions=i.helperProportions,this.instance.offset.click=i.offset.click,this.instance._intersectsWith(this.instance.containerCache)?(
//If it intersects, we use a little isOver variable and set it once, so our move-in stuff gets fired only once
this.instance.isOver||(this.instance.isOver=1,
//Now we fake the start of dragging for the sortable instance,
//by cloning the list group item, appending it to the sortable and using it as inst.currentItem
//We can then fire the start event of the sortable with our passed browser event, and our own helper (so it doesn't create a new one)
this.instance.currentItem=t(o).clone().removeAttr("id").appendTo(this.instance.element).data("sortable-item",!0),this.instance.options._helper=this.instance.options.helper,//Store helper option to later restore it
this.instance.options.helper=function(){return s.helper[0]},e.target=this.instance.currentItem[0],this.instance._mouseCapture(e,!0),this.instance._mouseStart(e,!0,!0),
//Because the browser event is way off the new appended portlet, we modify a couple of variables to reflect the changes
this.instance.offset.click.top=i.offset.click.top,this.instance.offset.click.left=i.offset.click.left,this.instance.offset.parent.left-=i.offset.parent.left-this.instance.offset.parent.left,this.instance.offset.parent.top-=i.offset.parent.top-this.instance.offset.parent.top,i._trigger("toSortable",e),i.dropped=this.instance.element,//draggable revert needs that
//hack so receive/update callbacks work (mostly)
i.currentItem=i.element,this.instance.fromOutside=i),
//Provided we did all the previous steps, we can fire the drag event of the sortable on every draggable drag, when it intersects with the sortable
this.instance.currentItem&&this.instance._mouseDrag(e)):
//If it doesn't intersect with the sortable, and it intersected before,
//we fake the drag stop of the sortable, but make sure it doesn't remove the helper by using cancelHelperRemoval
this.instance.isOver&&(this.instance.isOver=0,this.instance.cancelHelperRemoval=!0,
//Prevent reverting on this forced stop
this.instance.options.revert=!1,
// The out event needs to be triggered independently
this.instance._trigger("out",e,this.instance._uiHash(this.instance)),this.instance._mouseStop(e,!0),this.instance.options.helper=this.instance.options._helper,
//Now we remove our currentItem, the list group clone again, and the placeholder, and animate the helper back to it's original size
this.instance.currentItem.remove(),this.instance.placeholder&&this.instance.placeholder.remove(),i._trigger("fromSortable",e),i.dropped=!1)})}}),t.ui.plugin.add("draggable","cursor",{start:function(e,s){var i=t("body"),o=t(this).data("draggable").options;i.css("cursor")&&(o._cursor=i.css("cursor")),i.css("cursor",o.cursor)},stop:function(e,s){var i=t(this).data("draggable").options;i._cursor&&t("body").css("cursor",i._cursor)}}),t.ui.plugin.add("draggable","opacity",{start:function(e,s){var i=t(s.helper),o=t(this).data("draggable").options;i.css("opacity")&&(o._opacity=i.css("opacity")),i.css("opacity",o.opacity)},stop:function(e,s){var i=t(this).data("draggable").options;i._opacity&&t(s.helper).css("opacity",i._opacity)}}),t.ui.plugin.add("draggable","scroll",{start:function(e,s){var i=t(this).data("draggable");i.scrollParent[0]!=document&&"HTML"!=i.scrollParent[0].tagName&&(i.overflowOffset=i.scrollParent.offset())},drag:function(e,s){var i=t(this).data("draggable"),o=i.options,n=!1;i.scrollParent[0]!=document&&"HTML"!=i.scrollParent[0].tagName?(o.axis&&"x"==o.axis||(i.overflowOffset.top+i.scrollParent[0].offsetHeight-e.pageY<o.scrollSensitivity?i.scrollParent[0].scrollTop=n=i.scrollParent[0].scrollTop+o.scrollSpeed:e.pageY-i.overflowOffset.top<o.scrollSensitivity&&(i.scrollParent[0].scrollTop=n=i.scrollParent[0].scrollTop-o.scrollSpeed)),o.axis&&"y"==o.axis||(i.overflowOffset.left+i.scrollParent[0].offsetWidth-e.pageX<o.scrollSensitivity?i.scrollParent[0].scrollLeft=n=i.scrollParent[0].scrollLeft+o.scrollSpeed:e.pageX-i.overflowOffset.left<o.scrollSensitivity&&(i.scrollParent[0].scrollLeft=n=i.scrollParent[0].scrollLeft-o.scrollSpeed))):(o.axis&&"x"==o.axis||(e.pageY-t(document).scrollTop()<o.scrollSensitivity?n=t(document).scrollTop(t(document).scrollTop()-o.scrollSpeed):t(window).height()-(e.pageY-t(document).scrollTop())<o.scrollSensitivity&&(n=t(document).scrollTop(t(document).scrollTop()+o.scrollSpeed))),o.axis&&"y"==o.axis||(e.pageX-t(document).scrollLeft()<o.scrollSensitivity?n=t(document).scrollLeft(t(document).scrollLeft()-o.scrollSpeed):t(window).width()-(e.pageX-t(document).scrollLeft())<o.scrollSensitivity&&(n=t(document).scrollLeft(t(document).scrollLeft()+o.scrollSpeed)))),n!==!1&&t.ui.ddmanager&&!o.dropBehaviour&&t.ui.ddmanager.prepareOffsets(i,e)}}),t.ui.plugin.add("draggable","snap",{start:function(e,s){var i=t(this).data("draggable"),o=i.options;i.snapElements=[],t(o.snap.constructor!=String?o.snap.items||":data(draggable)":o.snap).each(function(){var e=t(this),s=e.offset();this!=i.element[0]&&i.snapElements.push({item:this,width:e.outerWidth(),height:e.outerHeight(),top:s.top,left:s.left})})},drag:function(e,s){for(var i=t(this).data("draggable"),o=i.options,n=o.snapTolerance,r=s.offset.left,a=r+i.helperProportions.width,l=s.offset.top,h=l+i.helperProportions.height,c=i.snapElements.length-1;c>=0;c--){var p=i.snapElements[c].left,f=p+i.snapElements[c].width,d=i.snapElements[c].top,g=d+i.snapElements[c].height;
//Yes, I know, this is insane ;)
if(p-n<r&&r<f+n&&d-n<l&&l<g+n||p-n<r&&r<f+n&&d-n<h&&h<g+n||p-n<a&&a<f+n&&d-n<l&&l<g+n||p-n<a&&a<f+n&&d-n<h&&h<g+n){if("inner"!=o.snapMode){var u=Math.abs(d-h)<=n,m=Math.abs(g-l)<=n,v=Math.abs(p-a)<=n,P=Math.abs(f-r)<=n;u&&(s.position.top=i._convertPositionTo("relative",{top:d-i.helperProportions.height,left:0}).top-i.margins.top),m&&(s.position.top=i._convertPositionTo("relative",{top:g,left:0}).top-i.margins.top),v&&(s.position.left=i._convertPositionTo("relative",{top:0,left:p-i.helperProportions.width}).left-i.margins.left),P&&(s.position.left=i._convertPositionTo("relative",{top:0,left:f}).left-i.margins.left)}var b=u||m||v||P;if("outer"!=o.snapMode){var u=Math.abs(d-l)<=n,m=Math.abs(g-h)<=n,v=Math.abs(p-r)<=n,P=Math.abs(f-a)<=n;u&&(s.position.top=i._convertPositionTo("relative",{top:d,left:0}).top-i.margins.top),m&&(s.position.top=i._convertPositionTo("relative",{top:g-i.helperProportions.height,left:0}).top-i.margins.top),v&&(s.position.left=i._convertPositionTo("relative",{top:0,left:p}).left-i.margins.left),P&&(s.position.left=i._convertPositionTo("relative",{top:0,left:f-i.helperProportions.width}).left-i.margins.left)}!i.snapElements[c].snapping&&(u||m||v||P||b)&&i.options.snap.snap&&i.options.snap.snap.call(i.element,e,t.extend(i._uiHash(),{snapItem:i.snapElements[c].item})),i.snapElements[c].snapping=u||m||v||P||b}else i.snapElements[c].snapping&&i.options.snap.release&&i.options.snap.release.call(i.element,e,t.extend(i._uiHash(),{snapItem:i.snapElements[c].item})),i.snapElements[c].snapping=!1}}}),t.ui.plugin.add("draggable","stack",{start:function(e,s){var i=t(this).data("draggable").options,o=t.makeArray(t(i.stack)).sort(function(e,s){return(parseInt(t(e).css("zIndex"),10)||0)-(parseInt(t(s).css("zIndex"),10)||0)});if(o.length){var n=parseInt(o[0].style.zIndex)||0;t(o).each(function(t){this.style.zIndex=n+t}),this[0].style.zIndex=n+o.length}}}),t.ui.plugin.add("draggable","zIndex",{start:function(e,s){var i=t(s.helper),o=t(this).data("draggable").options;i.css("zIndex")&&(o._zIndex=i.css("zIndex")),i.css("zIndex",o.zIndex)},stop:function(e,s){var i=t(this).data("draggable").options;i._zIndex&&t(s.helper).css("zIndex",i._zIndex)}})}(jQuery);