/*
 * File:        jquery.dataTables.js
 * Version:     1.6.2
 * CVS:         $Id$
 * Description: Paginate, search and sort HTML tables
 * Author:      Allan Jardine (www.sprymedia.co.uk)
 * Created:     28/3/2008
 * Modified:    $Date$ by $Author$
 * Language:    Javascript
 * License:     GPL v2 or BSD 3 point style
 * Project:     Mtaala
 * Contact:     allan.jardine@sprymedia.co.uk
 * 
 * Copyright 2008-2010 Allan Jardine, all rights reserved.
 *
 * This source file is free software, under either the GPL v2 license or a
 * BSD style license, as supplied with this software.
 * 
 * This source file is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 * 
 * For details pleease refer to: http://www.datatables.net
 */
/*
 * When considering jsLint, we need to allow eval() as it it is used for reading cookies and 
 * building the dynamic multi-column sort functions.
 */
/*jslint evil: true, undef: true, browser: true */
/*globals $, jQuery,_fnReadCookie,_fnProcessingDisplay,_fnDraw,_fnSort,_fnReDraw,_fnDetectType,_fnSortingClasses,_fnSettingsFromNode,_fnBuildSearchArray,_fnCalculateEnd,_fnFeatureHtmlProcessing,_fnFeatureHtmlPaginate,_fnFeatureHtmlInfo,_fnUpdateInfo,_fnFeatureHtmlFilter,_fnFilter,_fnSaveState,_fnFilterColumn,_fnEscapeRegex,_fnFilterComplete,_fnFeatureHtmlLength,_fnGetDataMaster,_fnVisibleToColumnIndex,_fnDrawHead,_fnAddData,_fnGetTrNodes,_fnGetTdNodes,_fnColumnIndexToVisible,_fnCreateCookie,_fnAddOptionsHtml,_fnMap,_fnClearTable,_fnDataToSearch,_fnReOrderIndex,_fnFilterCustom,_fnNodeToDataIndex,_fnVisbleColumns,_fnAjaxUpdate,_fnAjaxUpdateDraw,_fnColumnOrdering,fnGetMaxLenString,_fnSortAttachListener,_fnPageChange*/
!function($){/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Section - DataTables variables
	 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
	 * Variable: dataTableSettings
	 * Purpose:  Store the settings for each dataTables instance
	 * Scope:    jQuery.fn
	 */
$.fn.dataTableSettings=[];var _aoSettings=$.fn.dataTableSettings;/* Short reference for fast internal lookup */
/*
	 * Variable: dataTableExt
	 * Purpose:  Container for customisable parts of DataTables
	 * Scope:    jQuery.fn
	 */
$.fn.dataTableExt={};var _oExt=$.fn.dataTableExt;/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Section - DataTables extensible objects
	 * 
	 * The _oExt object is used to provide an area where user dfined plugins can be 
	 * added to DataTables. The following properties of the object are used:
	 *   oApi - Plug-in API functions
	 *   aTypes - Auto-detection of types
	 *   oSort - Sorting functions used by DataTables (based on the type)
	 *   oPagination - Pagination functions for different input styles
	 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
	 * Variable: sVersion
	 * Purpose:  Version string for plug-ins to check compatibility
	 * Scope:    jQuery.fn.dataTableExt
	 * Notes:    Allowed format is a.b.c.d.e where:
	 *   a:int, b:int, c:int, d:string(dev|beta), e:int. d and e are optional
	 */
_oExt.sVersion="1.6.2",/*
	 * Variable: iApiIndex
	 * Purpose:  Index for what 'this' index API functions should use
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt.iApiIndex=0,/*
	 * Variable: oApi
	 * Purpose:  Container for plugin API functions
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt.oApi={},/*
	 * Variable: aFiltering
	 * Purpose:  Container for plugin filtering functions
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt.afnFiltering=[],/*
	 * Variable: aoFeatures
	 * Purpose:  Container for plugin function functions
	 * Scope:    jQuery.fn.dataTableExt
	 * Notes:    Array of objects with the following parameters:
	 *   fnInit: Function for initialisation of Feature. Takes oSettings and returns node
	 *   cFeature: Character that will be matched in sDom - case sensitive
	 *   sFeature: Feature name - just for completeness :-)
	 */
_oExt.aoFeatures=[],/*
	 * Variable: ofnSearch
	 * Purpose:  Container for custom filtering functions
	 * Scope:    jQuery.fn.dataTableExt
	 * Notes:    This is an object (the name should match the type) for custom filtering function,
	 *   which can be used for live DOM checking or formatted text filtering
	 */
_oExt.ofnSearch={},/*
	 * Variable: afnSortData
	 * Purpose:  Container for custom sorting data source functions
	 * Scope:    jQuery.fn.dataTableExt
	 * Notes:    Array (associative) of functions which is run prior to a column of this 
	 *   'SortDataType' being sorted upon.
	 *   Function input parameters:
	 *     object:oSettings-  DataTables settings object
	 *     int:iColumn - Target column number
	 *   Return value: Array of data which exactly matched the full data set size for the column to
	 *     be sorted upon
	 */
_oExt.afnSortData=[],/*
	 * Variable: oStdClasses
	 * Purpose:  Storage for the various classes that DataTables uses
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt.oStdClasses={/* Two buttons buttons */
sPagePrevEnabled:"paginate_enabled_previous",sPagePrevDisabled:"paginate_disabled_previous",sPageNextEnabled:"paginate_enabled_next",sPageNextDisabled:"paginate_disabled_next",sPageJUINext:"",sPageJUIPrev:"",/* Full numbers paging buttons */
sPageButton:"paginate_button",sPageButtonActive:"paginate_active",sPageButtonStaticDisabled:"paginate_button",sPageFirst:"first",sPagePrevious:"previous",sPageNext:"next",sPageLast:"last",/* Stripping classes */
sStripOdd:"odd",sStripEven:"even",/* Empty row */
sRowEmpty:"dataTables_empty",/* Features */
sWrapper:"dataTables_wrapper",sFilter:"dataTables_filter",sInfo:"dataTables_info",sPaging:"dataTables_paginate paging_",/* Note that the type is postfixed */
sLength:"dataTables_length",sProcessing:"dataTables_processing",/* Sorting */
sSortAsc:"sorting_asc",sSortDesc:"sorting_desc",sSortable:"sorting",/* Sortable in both directions */
sSortableAsc:"sorting_asc_disabled",sSortableDesc:"sorting_desc_disabled",sSortableNone:"sorting_disabled",sSortColumn:"sorting_",/* Note that an int is postfixed for the sorting order */
sSortJUIAsc:"",sSortJUIDesc:"",sSortJUI:"",sSortJUIAscAllowed:"",sSortJUIDescAllowed:""},/*
	 * Variable: oJUIClasses
	 * Purpose:  Storage for the various classes that DataTables uses - jQuery UI suitable
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt.oJUIClasses={/* Two buttons buttons */
sPagePrevEnabled:"fg-button ui-state-default ui-corner-left",sPagePrevDisabled:"fg-button ui-state-default ui-corner-left ui-state-disabled",sPageNextEnabled:"fg-button ui-state-default ui-corner-right",sPageNextDisabled:"fg-button ui-state-default ui-corner-right ui-state-disabled",sPageJUINext:"ui-icon ui-icon-circle-arrow-e",sPageJUIPrev:"ui-icon ui-icon-circle-arrow-w",/* Full numbers paging buttons */
sPageButton:"fg-button ui-state-default",sPageButtonActive:"fg-button ui-state-default ui-state-disabled",sPageButtonStaticDisabled:"fg-button ui-state-default ui-state-disabled",sPageFirst:"first ui-corner-tl ui-corner-bl",sPagePrevious:"previous",sPageNext:"next",sPageLast:"last ui-corner-tr ui-corner-br",/* Stripping classes */
sStripOdd:"odd",sStripEven:"even",/* Empty row */
sRowEmpty:"dataTables_empty",/* Features */
sWrapper:"dataTables_wrapper",sFilter:"dataTables_filter",sInfo:"dataTables_info",sPaging:"dataTables_paginate fg-buttonset fg-buttonset-multi paging_",/* Note that the type is postfixed */
sLength:"dataTables_length",sProcessing:"dataTables_processing",/* Sorting */
sSortAsc:"ui-state-default",sSortDesc:"ui-state-default",sSortable:"ui-state-default",sSortableAsc:"ui-state-default",sSortableDesc:"ui-state-default",sSortableNone:"ui-state-default",sSortColumn:"sorting_",/* Note that an int is postfixed for the sorting order */
sSortJUIAsc:"css_right ui-icon ui-icon-triangle-1-n",sSortJUIDesc:"css_right ui-icon ui-icon-triangle-1-s",sSortJUI:"css_right ui-icon ui-icon-carat-2-n-s",sSortJUIAscAllowed:"css_right ui-icon ui-icon-carat-1-n",sSortJUIDescAllowed:"css_right ui-icon ui-icon-carat-1-s"},/*
	 * Variable: oPagination
	 * Purpose:  Container for the various type of pagination that dataTables supports
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt.oPagination={/*
		 * Variable: two_button
		 * Purpose:  Standard two button (forward/back) pagination
	 	 * Scope:    jQuery.fn.dataTableExt.oPagination
		 */
two_button:{/*
			 * Function: oPagination.two_button.fnInit
			 * Purpose:  Initalise dom elements required for pagination with forward/back buttons only
			 * Returns:  -
	 		 * Inputs:   object:oSettings - dataTables settings object
	     *           node:nPaging - the DIV which contains this pagination control
			 *           function:fnCallbackDraw - draw function which must be called on update
			 */
fnInit:function(e,a,t){var n,o,s,i;/* Store the next and previous elements in the oSettings object as they can be very
				 * usful for automation - particularly testing
				 */
e.bJUI?(n=document.createElement("a"),o=document.createElement("a"),i=document.createElement("span"),i.className=e.oClasses.sPageJUINext,o.appendChild(i),s=document.createElement("span"),s.className=e.oClasses.sPageJUIPrev,n.appendChild(s)):(n=document.createElement("div"),o=document.createElement("div")),n.className=e.oClasses.sPagePrevDisabled,o.className=e.oClasses.sPageNextDisabled,n.title=e.oLanguage.oPaginate.sPrevious,o.title=e.oLanguage.oPaginate.sNext,a.appendChild(n),a.appendChild(o),$(n).click(function(){e.oApi._fnPageChange(e,"previous")&&/* Only draw when the page has actually changed */
t(e)}),$(o).click(function(){e.oApi._fnPageChange(e,"next")&&t(e)}),/* Take the brutal approach to cancelling text selection */
$(n).bind("selectstart",function(){return!1}),$(o).bind("selectstart",function(){return!1}),/* ID the first elements only */
""!==e.sTableId&&"undefined"==typeof e.aanFeatures.p&&(a.setAttribute("id",e.sTableId+"_paginate"),n.setAttribute("id",e.sTableId+"_previous"),o.setAttribute("id",e.sTableId+"_next"))},/*
			 * Function: oPagination.two_button.fnUpdate
			 * Purpose:  Update the two button pagination at the end of the draw
			 * Returns:  -
	 		 * Inputs:   object:oSettings - dataTables settings object
			 *           function:fnCallbackDraw - draw function to call on page change
			 */
fnUpdate:function(e,a){if(e.aanFeatures.p)for(var t=e.aanFeatures.p,n=0,o=t.length;n<o;n++)0!==t[n].childNodes.length&&(t[n].childNodes[0].className=0===e._iDisplayStart?e.oClasses.sPagePrevDisabled:e.oClasses.sPagePrevEnabled,t[n].childNodes[1].className=e.fnDisplayEnd()==e.fnRecordsDisplay()?e.oClasses.sPageNextDisabled:e.oClasses.sPageNextEnabled)}},/*
		 * Variable: iFullNumbersShowPages
		 * Purpose:  Change the number of pages which can be seen
	 	 * Scope:    jQuery.fn.dataTableExt.oPagination
		 */
iFullNumbersShowPages:5,/*
		 * Variable: full_numbers
		 * Purpose:  Full numbers pagination
	 	 * Scope:    jQuery.fn.dataTableExt.oPagination
		 */
full_numbers:{/*
			 * Function: oPagination.full_numbers.fnInit
			 * Purpose:  Initalise dom elements required for pagination with a list of the pages
			 * Returns:  -
	 		 * Inputs:   object:oSettings - dataTables settings object
	     *           node:nPaging - the DIV which contains this pagination control
			 *           function:fnCallbackDraw - draw function which must be called on update
			 */
fnInit:function(e,a,t){var n=document.createElement("span"),o=document.createElement("span"),s=document.createElement("span"),i=document.createElement("span"),r=document.createElement("span");n.innerHTML=e.oLanguage.oPaginate.sFirst,o.innerHTML=e.oLanguage.oPaginate.sPrevious,i.innerHTML=e.oLanguage.oPaginate.sNext,r.innerHTML=e.oLanguage.oPaginate.sLast;var l=e.oClasses;n.className=l.sPageButton+" "+l.sPageFirst,o.className=l.sPageButton+" "+l.sPagePrevious,i.className=l.sPageButton+" "+l.sPageNext,r.className=l.sPageButton+" "+l.sPageLast,a.appendChild(n),a.appendChild(o),a.appendChild(s),a.appendChild(i),a.appendChild(r),$(n).click(function(){e.oApi._fnPageChange(e,"first")&&t(e)}),$(o).click(function(){e.oApi._fnPageChange(e,"previous")&&t(e)}),$(i).click(function(){e.oApi._fnPageChange(e,"next")&&t(e)}),$(r).click(function(){e.oApi._fnPageChange(e,"last")&&t(e)}),/* Take the brutal approach to cancelling text selection */
$("span",a).bind("mousedown",function(){return!1}).bind("selectstart",function(){return!1}),/* ID the first elements only */
""!==e.sTableId&&"undefined"==typeof e.aanFeatures.p&&(a.setAttribute("id",e.sTableId+"_paginate"),n.setAttribute("id",e.sTableId+"_first"),o.setAttribute("id",e.sTableId+"_previous"),i.setAttribute("id",e.sTableId+"_next"),r.setAttribute("id",e.sTableId+"_last"))},/*
			 * Function: oPagination.full_numbers.fnUpdate
			 * Purpose:  Update the list of page buttons shows
			 * Returns:  -
	 		 * Inputs:   object:oSettings - dataTables settings object
			 *           function:fnCallbackDraw - draw function to call on page change
			 */
fnUpdate:function(e,a){if(e.aanFeatures.p){var t,n,o,s,i=_oExt.oPagination.iFullNumbersShowPages,r=Math.floor(i/2),l=Math.ceil(e.fnRecordsDisplay()/e._iDisplayLength),u=Math.ceil(e._iDisplayStart/e._iDisplayLength)+1,f="",d=e.oClasses;/* Build the dynamic list */
for(/* Pages calculation */
l<i?(t=1,n=l):u<=r?(t=1,n=i):u>=l-r?(t=l-i+1,n=l):(t=u-Math.ceil(i/2)+1,n=t+i-1),o=t;o<=n;o++)f+=u!=o?'<span class="'+d.sPageButton+'">'+o+"</span>":'<span class="'+d.sPageButtonActive+'">'+o+"</span>";/* Loop over each instance of the pager */
var p,g,c,h=e.aanFeatures.p,_=function(){/* Use the information in the element to jump to the required page */
var t=1*this.innerHTML-1;return e._iDisplayStart=t*e._iDisplayLength,a(e),!1},S=function(){return!1};for(o=0,s=h.length;o<s;o++)0!==h[o].childNodes.length&&(/* Build up the dynamic list forst - html and listeners */
c=h[o].childNodes[2],c.innerHTML=f,$("span",c).click(_).bind("mousedown",S).bind("selectstart",S),/* Update the 'premanent botton's classes */
p=h[o].getElementsByTagName("span"),g=[p[0],p[1],p[p.length-2],p[p.length-1]],$(g).removeClass(d.sPageButton+" "+d.sPageButtonActive+" "+d.sPageButtonStaticDisabled),1==u?(g[0].className+=" "+d.sPageButtonStaticDisabled,g[1].className+=" "+d.sPageButtonStaticDisabled):(g[0].className+=" "+d.sPageButton,g[1].className+=" "+d.sPageButton),0===l||u==l||e._iDisplayLength==-1?(g[2].className+=" "+d.sPageButtonStaticDisabled,g[3].className+=" "+d.sPageButtonStaticDisabled):(g[2].className+=" "+d.sPageButton,g[3].className+=" "+d.sPageButton),/* EllisLab edit */
$(g[0])[u<4?"hide":"show"](),// first 3 pages, no "first" link
$(g[1])[1==u?"hide":"show"](),// first page, no "previous" link
$(g[2])[u==l?"hide":"show"](),// last page, no "next" link
$(g[3])[u>l-3?"hide":"show"]())}}}},/*
	 * Variable: oSort
	 * Purpose:  Wrapper for the sorting functions that can be used in DataTables
	 * Scope:    jQuery.fn.dataTableExt
	 * Notes:    The functions provided in this object are basically standard javascript sort
	 *   functions - they expect two inputs which they then compare and then return a priority
	 *   result. For each sort method added, two functions need to be defined, an ascending sort and
	 *   a descending sort.
	 */
_oExt.oSort={/*
		 * text sorting
		 */
"string-asc":function(e,a){var t=e.toLowerCase(),n=a.toLowerCase();return t<n?-1:t>n?1:0},"string-desc":function(e,a){var t=e.toLowerCase(),n=a.toLowerCase();return t<n?1:t>n?-1:0},/*
		 * html sorting (ignore html tags)
		 */
"html-asc":function(e,a){var t=e.replace(/<.*?>/g,"").toLowerCase(),n=a.replace(/<.*?>/g,"").toLowerCase();return t<n?-1:t>n?1:0},"html-desc":function(e,a){var t=e.replace(/<.*?>/g,"").toLowerCase(),n=a.replace(/<.*?>/g,"").toLowerCase();return t<n?1:t>n?-1:0},/*
		 * date sorting
		 */
"date-asc":function(e,a){var t=Date.parse(e),n=Date.parse(a);return isNaN(t)&&(t=Date.parse("01/01/1970 00:00:00")),isNaN(n)&&(n=Date.parse("01/01/1970 00:00:00")),t-n},"date-desc":function(e,a){var t=Date.parse(e),n=Date.parse(a);return isNaN(t)&&(t=Date.parse("01/01/1970 00:00:00")),isNaN(n)&&(n=Date.parse("01/01/1970 00:00:00")),n-t},/*
		 * numerical sorting
		 */
"numeric-asc":function(e,a){var t="-"==e?0:e,n="-"==a?0:a;return t-n},"numeric-desc":function(e,a){var t="-"==e?0:e,n="-"==a?0:a;return n-t}},/*
	 * Variable: aTypes
	 * Purpose:  Container for the various type of type detection that dataTables supports
	 * Scope:    jQuery.fn.dataTableExt
	 * Notes:    The functions in this array are expected to parse a string to see if it is a data
	 *   type that it recognises. If so then the function should return the name of the type (a
	 *   corresponding sort function should be defined!), if the type is not recognised then the
	 *   function should return null such that the parser and move on to check the next type.
	 *   Note that ordering is important in this array - the functions are processed linearly,
	 *   starting at index 0.
	 */
_oExt.aTypes=[/*
		 * Function: -
		 * Purpose:  Check to see if a string is numeric
		 * Returns:  string:'numeric' or null
		 * Inputs:   string:sText - string to check
		 */
function(e){/* Sanity check that we are dealing with a string or quick return for a number */
if("number"==typeof e)return"numeric";if("function"!=typeof e.charAt)return null;var a,t="0123456789-",n="0123456789.",o=!1;if(/* Check for a valid first char (no period and allow negatives) */
a=e.charAt(0),t.indexOf(a)==-1)return null;/* Check all the other characters are valid */
for(var s=1;s<e.length;s++){if(a=e.charAt(s),n.indexOf(a)==-1)return null;/* Only allowed one decimal place... */
if("."==a){if(o)return null;o=!0}}return"numeric"},/*
		 * Function: -
		 * Purpose:  Check to see if a string is actually a formatted date
		 * Returns:  string:'date' or null
		 * Inputs:   string:sText - string to check
		 */
function(e){var a=Date.parse(e);return null===a||isNaN(a)?null:"date"}],/*
	 * Variable: _oExternConfig
	 * Purpose:  Store information for DataTables to access globally about other instances
	 * Scope:    jQuery.fn.dataTableExt
	 */
_oExt._oExternConfig={/* int:iNextUnique - next unique number for an instance */
iNextUnique:0},/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Section - DataTables prototype
	 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
	 * Function: dataTable
	 * Purpose:  DataTables information
	 * Returns:  -
	 * Inputs:   object:oInit - initalisation options for the table
	 */
$.fn.dataTable=function(oInit){/*
		 * Function: classSettings
		 * Purpose:  Settings container function for all 'class' properties which are required
		 *   by dataTables
		 * Returns:  -
		 * Inputs:   -
		 */
function classSettings(){this.fnRecordsTotal=function(){return this.oFeatures.bServerSide?this._iRecordsTotal:this.aiDisplayMaster.length},this.fnRecordsDisplay=function(){return this.oFeatures.bServerSide?this._iRecordsDisplay:this.aiDisplay.length},this.fnDisplayEnd=function(){return this.oFeatures.bServerSide?this._iDisplayStart+this.aiDisplay.length:this._iDisplayEnd},/*
			 * Variable: sInstance
			 * Purpose:  Unique idendifier for each instance of the DataTables object
			 * Scope:    jQuery.dataTable.classSettings 
			 */
this.sInstance=null,/*
			 * Variable: oFeatures
			 * Purpose:  Indicate the enablement of key dataTable features
			 * Scope:    jQuery.dataTable.classSettings 
			 */
this.oFeatures={bPaginate:!0,bLengthChange:!0,bFilter:!0,bSort:!0,bInfo:!0,bAutoWidth:!0,bProcessing:!1,bSortClasses:!0,bStateSave:!1,bServerSide:!1},/*
			 * Variable: aanFeatures
			 * Purpose:  Array referencing the nodes which are used for the features
			 * Scope:    jQuery.dataTable.classSettings 
			 * Notes:    The parameters of this object match what is allowed by sDom - i.e.
			 *   'l' - Length changing
			 *   'f' - Filtering input
			 *   't' - The table!
			 *   'i' - Information
			 *   'p' - Pagination
			 *   'r' - pRocessing
			 */
this.aanFeatures=[],/*
			 * Variable: oLanguage
			 * Purpose:  Store the language strings used by dataTables
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    The words in the format _VAR_ are variables which are dynamically replaced
			 *   by javascript
			 */
this.oLanguage={sProcessing:"Processing...",sLengthMenu:"Show _MENU_ entries",sZeroRecords:"No matching records found",sInfo:"Showing _START_ to _END_ of _TOTAL_ entries",sInfoEmpty:"Showing 0 to 0 of 0 entries",sInfoFiltered:"(filtered from _MAX_ total entries)",sInfoPostFix:"",sSearch:"Search:",sUrl:"",oPaginate:{sFirst:"First",sPrevious:"Previous",sNext:"Next",sLast:"Last"}},/*
			 * Variable: aoData
			 * Purpose:  Store data information
			 * Scope:    jQuery.dataTable.classSettings 
			 * Notes:    This is an array of objects with the following parameters:
			 *   int: _iId - internal id for tracking
			 *   array: _aData - internal data - used for sorting / filtering etc
			 *   node: nTr - display node
			 *   array node: _anHidden - hidden TD nodes
			 *   string: _sRowStripe
			 */
this.aoData=[],/*
			 * Variable: aiDisplay
			 * Purpose:  Array of indexes which are in the current display (after filtering etc)
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.aiDisplay=[],/*
			 * Variable: aiDisplayMaster
			 * Purpose:  Array of indexes for display - no filtering
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.aiDisplayMaster=[],/*
			 * Variable: aoColumns
			 * Purpose:  Store information about each column that is in use
			 * Scope:    jQuery.dataTable.classSettings 
			 */
this.aoColumns=[],/*
			 * Variable: iNextId
			 * Purpose:  Store the next unique id to be used for a new row
			 * Scope:    jQuery.dataTable.classSettings 
			 */
this.iNextId=0,/*
			 * Variable: asDataSearch
			 * Purpose:  Search data array for regular expression searching
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.asDataSearch=[],/*
			 * Variable: oPreviousSearch
			 * Purpose:  Store the previous search incase we want to force a re-search
			 *   or compare the old search to a new one
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.oPreviousSearch={sSearch:"",bEscapeRegex:!0},/*
			 * Variable: aoPreSearchCols
			 * Purpose:  Store the previous search for each column
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.aoPreSearchCols=[],/*
			 * Variable: aaSorting
			 * Purpose:  Sorting information
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    Index 0 - column number
			 *           Index 1 - current sorting direction
			 *           Index 2 - index of asSorting for this column
			 */
this.aaSorting=[[0,"asc",0]],/*
			 * Variable: aaSortingFixed
			 * Purpose:  Sorting information that is always applied
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.aaSortingFixed=null,/*
			 * Variable: asStripClasses
			 * Purpose:  Classes to use for the striping of a table
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.asStripClasses=[],/*
			 * Variable: fnRowCallback
			 * Purpose:  Call this function every time a row is inserted (draw)
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.fnRowCallback=null,/*
			 * Variable: fnHeaderCallback
			 * Purpose:  Callback function for the header on each draw
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.fnHeaderCallback=null,/*
			 * Variable: fnFooterCallback
			 * Purpose:  Callback function for the footer on each draw
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.fnFooterCallback=null,/*
			 * Variable: aoDrawCallback
			 * Purpose:  Array of callback functions for draw callback functions
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    Each array element is an object with the following parameters:
			 *   function:fn - function to call
			 *   string:sName - name callback (feature). useful for arranging array
			 */
this.aoDrawCallback=[],/*
			 * Variable: fnInitComplete
			 * Purpose:  Callback function for when the table has been initalised
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.fnInitComplete=null,/*
			 * Variable: sTableId
			 * Purpose:  Cache the table ID for quick access
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.sTableId="",/*
			 * Variable: nTable
			 * Purpose:  Cache the table node for quick access
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.nTable=null,/*
			 * Variable: iDefaultSortIndex
			 * Purpose:  Sorting index which will be used by default
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.iDefaultSortIndex=0,/*
			 * Variable: bInitialised
			 * Purpose:  Indicate if all required information has been read in
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.bInitialised=!1,/*
			 * Variable: aoOpenRows
			 * Purpose:  Information about open rows
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    Has the parameters 'nTr' and 'nParent'
			 */
this.aoOpenRows=[],/*
			 * Variable: sDom
			 * Purpose:  Dictate the positioning that the created elements will take
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    
			 *   The following options are allowed:
			 *     'l' - Length changing
			 *     'f' - Filtering input
			 *     't' - The table!
			 *     'i' - Information
			 *     'p' - Pagination
			 *     'r' - pRocessing
			 *   The following constants are allowed:
			 *     'H' - jQueryUI theme "header" classes
			 *     'F' - jQueryUI theme "footer" classes
			 *   The following syntax is expected:
			 *     '<' and '>' - div elements
			 *     '<"class" and '>' - div with a class
			 *   Examples:
			 *     '<"wrapper"flipt>', '<lf<t>ip>'
			 */
this.sDom="lfrtip",/*
			 * Variable: sPaginationType
			 * Purpose:  Note which type of sorting should be used
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.sPaginationType="two_button",/*
			 * Variable: iCookieDuration
			 * Purpose:  The cookie duration (for bStateSave) in seconds - default 2 hours
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.iCookieDuration=7200,/*
			 * Variable: sAjaxSource
			 * Purpose:  Source url for AJAX data for the table
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.sAjaxSource=null,/*
			 * Variable: bAjaxDataGet
			 * Purpose:  Note if draw should be blocked while getting data
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.bAjaxDataGet=!0,/*
			 * Variable: fnServerData
			 * Purpose:  Function to get the server-side data - can be overruled by the developer
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.fnServerData=$.getJSON,/*
			 * Variable: iServerDraw
			 * Purpose:  Counter and tracker for server-side processing draws
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.iServerDraw=0,/*
			 * Variable: _iDisplayLength, _iDisplayStart, _iDisplayEnd
			 * Purpose:  Display length variables
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    These variable must NOT be used externally to get the data length. Rather, use
			 *   the fnRecordsTotal() (etc) functions.
			 */
this._iDisplayLength=10,this._iDisplayStart=0,this._iDisplayEnd=10,/*
			 * Variable: _iRecordsTotal, _iRecordsDisplay
			 * Purpose:  Display length variables used for server side processing
			 * Scope:    jQuery.dataTable.classSettings
			 * Notes:    These variable must NOT be used externally to get the data length. Rather, use
			 *   the fnRecordsTotal() (etc) functions.
			 */
this._iRecordsTotal=0,this._iRecordsDisplay=0,/*
			 * Variable: bJUI
			 * Purpose:  Should we add the markup needed for jQuery UI theming?
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.bJUI=!1,/*
			 * Variable: bJUI
			 * Purpose:  Should we add the markup needed for jQuery UI theming?
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.oClasses=_oExt.oStdClasses,/*
			 * Variable: bFiltered and bSorted
			 * Purpose:  Flag to allow callback functions to see what action has been performed
			 * Scope:    jQuery.dataTable.classSettings
			 */
this.bFiltered=!1,this.bSorted=!1}/*
		 * Plugin API functions
		 * 
		 * This call will add the functions which are defined in _oExt.oApi to the
		 * DataTables object, providing a rather nice way to allow plug-in API functions. Note that
		 * this is done here, so that API function can actually override the built in API functions if
		 * required for a particular purpose.
		 */
/*
		 * Function: _fnExternApiFunc
		 * Purpose:  Create a wrapper function for exporting an internal func to an external API func
		 * Returns:  function: - wrapped function
		 * Inputs:   string:sFunc - API function name
		 */
function _fnExternApiFunc(e){return function(){var a=[_fnSettingsFromNode(this[_oExt.iApiIndex])].concat(Array.prototype.slice.call(arguments));return _oExt.oApi[e].apply(this,a)}}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Local functions
		 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Initalisation
		 */
/*
		 * Function: _fnInitalise
		 * Purpose:  Draw the table for the first time, adding all required features
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnInitalise(e){/* Ensure that the table data is fully initialised */
/* Ensure that the table data is fully initialised */
/* Show the display HTML options */
/* Draw the headers for the table */
/* If there is default sorting required - let's do it. The sort function
			 * will do the drawing for us. Otherwise we draw the table
			 */
/*
				 * Add the sorting classes to the header and the body (if needed).
				 * Reason for doing it here after the first draw is to stop classes being applied to the
				 * 'static' table.
				 */
/* if there is an ajax source */
/* Run the init callback if there is one */
return e.bInitialised===!1?void setTimeout(function(){_fnInitalise(e)},200):(_fnAddOptionsHtml(e),_fnDrawHead(e),e.oFeatures.bSort?(_fnSort(e,!1),_fnSortingClasses(e)):(e.aiDisplay=e.aiDisplayMaster.slice(),_fnCalculateEnd(e),_fnDraw(e)),null===e.sAjaxSource||e.oFeatures.bServerSide?("function"==typeof e.fnInitComplete&&e.fnInitComplete(e),void(e.oFeatures.bServerSide||_fnProcessingDisplay(e,!1))):(_fnProcessingDisplay(e,!0),void e.fnServerData(e.sAjaxSource,null,function(a){/* Got the data - add it to the table */
for(var t=0;t<a.aaData.length;t++)_fnAddData(e,a.aaData[t]);/* Reset the init display for cookie saving. We've already done a filter, and
					 * therefore cleared it before. So we need to make it appear 'fresh'
					 */
e.iInitDisplayStart=e._iDisplayStart,e.oFeatures.bSort?_fnSort(e):(e.aiDisplay=e.aiDisplayMaster.slice(),_fnCalculateEnd(e),_fnDraw(e)),_fnProcessingDisplay(e,!1),/* Run the init callback if there is one */
"function"==typeof e.fnInitComplete&&e.fnInitComplete(e,a)})))}/*
		 * Function: _fnLanguageProcess
		 * Purpose:  Copy language variables from remote object to a local one
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           object:oLanguage - Language information
		 *           bool:bInit - init once complete
		 */
function _fnLanguageProcess(e,a,t){_fnMap(e.oLanguage,a,"sProcessing"),_fnMap(e.oLanguage,a,"sLengthMenu"),_fnMap(e.oLanguage,a,"sZeroRecords"),_fnMap(e.oLanguage,a,"sInfo"),_fnMap(e.oLanguage,a,"sInfoEmpty"),_fnMap(e.oLanguage,a,"sInfoFiltered"),_fnMap(e.oLanguage,a,"sInfoPostFix"),_fnMap(e.oLanguage,a,"sSearch"),"undefined"!=typeof a.oPaginate&&(_fnMap(e.oLanguage.oPaginate,a.oPaginate,"sFirst"),_fnMap(e.oLanguage.oPaginate,a.oPaginate,"sPrevious"),_fnMap(e.oLanguage.oPaginate,a.oPaginate,"sNext"),_fnMap(e.oLanguage.oPaginate,a.oPaginate,"sLast")),t&&_fnInitalise(e)}/*
		 * Function: _fnAddColumn
		 * Purpose:  Add a column to the list used for the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           object:oOptions - object with sType, bVisible and bSearchable
		 *           node:nTh - the th element for this column
		 * Notes:    All options in enter column can be over-ridden by the user
		 *   initialisation of dataTables
		 */
function _fnAddColumn(e,a,t){e.aoColumns[e.aoColumns.length++]={sType:null,_bAutoType:!0,bVisible:!0,bSearchable:!0,bSortable:!0,asSorting:["asc","desc"],sSortingClass:e.oClasses.sSortable,sSortingClassJUI:e.oClasses.sSortJUI,sTitle:t?t.innerHTML:"",sName:"",sWidth:null,sClass:null,fnRender:null,bUseRendered:!0,iDataSort:e.aoColumns.length-1,sSortDataType:"std",nTh:t?t:document.createElement("th"),nTf:null};var n=e.aoColumns.length-1,o=e.aoColumns[n];/* User specified column options */
"undefined"!=typeof a&&null!==a&&("undefined"!=typeof a.sType&&(o.sType=a.sType,o._bAutoType=!1),_fnMap(o,a,"bVisible"),_fnMap(o,a,"bSearchable"),_fnMap(o,a,"bSortable"),_fnMap(o,a,"sTitle"),_fnMap(o,a,"sName"),_fnMap(o,a,"sWidth"),_fnMap(o,a,"sClass"),_fnMap(o,a,"fnRender"),_fnMap(o,a,"bUseRendered"),_fnMap(o,a,"iDataSort"),_fnMap(o,a,"asSorting"),_fnMap(o,a,"sSortDataType")),/* Feature sorting overrides column specific when off */
e.oFeatures.bSort||(o.bSortable=!1),/* Check that the class assignment is correct for sorting */
!o.bSortable||$.inArray("asc",o.asSorting)==-1&&$.inArray("desc",o.asSorting)==-1?(o.sSortingClass=e.oClasses.sSortableNone,o.sSortingClassJUI=""):$.inArray("asc",o.asSorting)!=-1&&$.inArray("desc",o.asSorting)==-1?(o.sSortingClass=e.oClasses.sSortableAsc,o.sSortingClassJUI=e.oClasses.sSortJUIAscAllowed):$.inArray("asc",o.asSorting)==-1&&$.inArray("desc",o.asSorting)!=-1&&(o.sSortingClass=e.oClasses.sSortableDesc,o.sSortingClassJUI=e.oClasses.sSortJUIDescAllowed),/* Add a column specific filter */
"undefined"==typeof e.aoPreSearchCols[n]||null===e.aoPreSearchCols[n]?e.aoPreSearchCols[n]={sSearch:"",bEscapeRegex:!0}:"undefined"==typeof e.aoPreSearchCols[n].bEscapeRegex&&(/* Don't require that the user must specify bEscapeRegex */
e.aoPreSearchCols[n].bEscapeRegex=!0)}/*
		 * Function: _fnAddData
		 * Purpose:  Add a data array to the table, creating DOM node etc
		 * Returns:  int: - >=0 if successful (index of new aoData entry), -1 if failed
		 * Inputs:   object:oSettings - dataTables settings object
		 *           array:aData - data array to be added
		 */
function _fnAddData(e,a){/* Sanity check the length of the new array */
if(a.length!=e.aoColumns.length)return alert("DataTables warning: Added data does not match known number of columns"),-1;/* Create the object for storing information about this new row */
var t=e.aoData.length;e.aoData.push({nTr:document.createElement("tr"),_iId:e.iNextId++,_aData:a.slice(),_anHidden:[],_sRowStripe:""});for(var n,o,s=0;s<a.length;s++){if(n=document.createElement("td"),"function"==typeof e.aoColumns[s].fnRender){var i=e.aoColumns[s].fnRender({iDataRow:t,iDataColumn:s,aData:a,oSettings:e});n.innerHTML=i,e.aoColumns[s].bUseRendered&&(/* Use the rendered data for filtering/sorting */
e.aoData[t]._aData[s]=i)}else n.innerHTML=a[s];null!==e.aoColumns[s].sClass&&(n.className=e.aoColumns[s].sClass),/* See if we should auto-detect the column type */
e.aoColumns[s]._bAutoType&&"string"!=e.aoColumns[s].sType&&(/* Attempt to auto detect the type - same as _fnGatherData() */
o=_fnDetectType(e.aoData[t]._aData[s]),null===e.aoColumns[s].sType?e.aoColumns[s].sType=o:e.aoColumns[s].sType!=o&&(/* String is always the 'fallback' option */
e.aoColumns[s].sType="string")),e.aoColumns[s].bVisible?e.aoData[t].nTr.appendChild(n):e.aoData[t]._anHidden[s]=n}/* Add to the display array */
return e.aiDisplayMaster.push(t),t}/*
		 * Function: _fnGatherData
		 * Purpose:  Read in the data from the target table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnGatherData(e){var a,t,n,o,s,i,r,l,u,f,d,p,g,c;/*
			 * Process by row first
			 * Add the data object for the whole table - storing the tr node. Note - no point in getting
			 * DOM based data if we are going to go and replace it with Ajax source data.
			 */
if(null===e.sAjaxSource)for(r=e.nTable.getElementsByTagName("tbody")[0].childNodes,a=0,t=r.length;a<t;a++)if("TR"==r[a].nodeName)for(f=e.aoData.length,e.aoData.push({nTr:r[a],_iId:e.iNextId++,_aData:[],_anHidden:[],_sRowStripe:""}),e.aiDisplayMaster.push(f),u=e.aoData[f]._aData,i=r[a].childNodes,s=0,n=0,o=i.length;n<o;n++)"TD"==i[n].nodeName&&(u[s]=i[n].innerHTML,s++);for(/* Gather in the TD elements of the Table - note that this is basically the same as
			 * fnGetTdNodes, but that function takes account of hidden columns, which we haven't yet
			 * setup!
			 */
r=_fnGetTrNodes(e),i=[],a=0,t=r.length;a<t;a++)for(n=0,o=r[a].childNodes.length;n<o;n++)l=r[a].childNodes[n],"TD"==l.nodeName&&i.push(l);/* Now process by column */
for(/* Sanity check */
i.length!=r.length*e.aoColumns.length&&alert("DataTables warning: Unexpected number of TD elements. Expected "+r.length*e.aoColumns.length+" and got "+i.length+". DataTables does not support rowspan / colspan in the table body, and there must be one cell for each row/column combination."),g=0,c=e.aoColumns.length;g<c;g++){/* Get the title of the column - unless there is a user set one */
null===e.aoColumns[g].sTitle&&(e.aoColumns[g].sTitle=e.aoColumns[g].nTh.innerHTML);var h,_,S,D=e.aoColumns[g]._bAutoType,m="function"==typeof e.aoColumns[g].fnRender,C=null!==e.aoColumns[g].sClass,b=e.aoColumns[g].bVisible;/* A single loop to rule them all (and be more efficient) */
if(D||m||C||!b)for(d=0,p=e.aoData.length;d<p;d++)h=i[d*c+g],/* Type detection */
D&&"string"!=e.aoColumns[g].sType&&(_=_fnDetectType(e.aoData[d]._aData[g]),null===e.aoColumns[g].sType?e.aoColumns[g].sType=_:e.aoColumns[g].sType!=_&&(/* String is always the 'fallback' option */
e.aoColumns[g].sType="string")),/* Rendering */
m&&(S=e.aoColumns[g].fnRender({iDataRow:d,iDataColumn:g,aData:e.aoData[d]._aData,oSettings:e}),h.innerHTML=S,e.aoColumns[g].bUseRendered&&(/* Use the rendered data for filtering/sorting */
e.aoData[d]._aData[g]=S)),/* Classes */
C&&(h.className+=" "+e.aoColumns[g].sClass),/* Column visability */
b||(e.aoData[d]._anHidden[g]=h,h.parentNode.removeChild(h))}}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Drawing functions
		 */
/*
		 * Function: _fnDrawHead
		 * Purpose:  Create the HTML header for the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnDrawHead(e){var a,t,n,o=e.nTable.getElementsByTagName("thead")[0].getElementsByTagName("th").length,s=0;/* If there is a header in place - then use it - otherwise it's going to get nuked... */
if(0!==o)/* We've got a thead from the DOM, so remove hidden columns and apply width to vis cols */
for(a=0,n=e.aoColumns.length;a<n;a++)
//oSettings.aoColumns[i].nTh = nThs[i];
t=e.aoColumns[a].nTh,e.aoColumns[a].bVisible?(/* Set width */
null!==e.aoColumns[a].sWidth&&(t.style.width=e.aoColumns[a].sWidth),/* Set the title of the column if it is user defined (not what was auto detected) */
e.aoColumns[a].sTitle!=t.innerHTML&&(t.innerHTML=e.aoColumns[a].sTitle)):(t.parentNode.removeChild(t),s++);else{/* We don't have a header in the DOM - so we are going to have to create one */
var i=document.createElement("tr");for(a=0,n=e.aoColumns.length;a<n;a++)t=e.aoColumns[a].nTh,t.innerHTML=e.aoColumns[a].sTitle,e.aoColumns[a].bVisible&&(null!==e.aoColumns[a].sClass&&(t.className=e.aoColumns[a].sClass),null!==e.aoColumns[a].sWidth&&(t.style.width=e.aoColumns[a].sWidth),i.appendChild(t));$("thead:eq(0)",e.nTable).html("")[0].appendChild(i)}/* Add the extra markup needed by jQuery UI's themes */
if(e.bJUI)for(a=0,n=e.aoColumns.length;a<n;a++)e.aoColumns[a].nTh.insertBefore(document.createElement("span"),e.aoColumns[a].nTh.firstChild);/* Add sort listener */
if(e.oFeatures.bSort){for(a=0;a<e.aoColumns.length;a++)e.aoColumns[a].bSortable!==!1?_fnSortAttachListener(e,e.aoColumns[a].nTh,a):$(e.aoColumns[a].nTh).addClass(e.oClasses.sSortableNone);/* Take the brutal approach to cancelling text selection due to the shift key */
$("thead:eq(0) th",e.nTable).mousedown(function(e){if(e.shiftKey)return this.onselectstart=function(){return!1},!1})}/* Cache the footer elements */
var r=e.nTable.getElementsByTagName("tfoot");if(0!==r.length){s=0;var l=r[0].getElementsByTagName("th");for(a=0,n=l.length;a<n;a++)e.aoColumns[a].nTf=l[a-s],e.aoColumns[a].bVisible||(l[a-s].parentNode.removeChild(l[a-s]),s++)}}/*
		 * Function: _fnDraw
		 * Purpose:  Insert the required TR nodes into the table for display
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnDraw(e){var a,t,n=[],o=0,s=!1,i=e.asStripClasses.length,r=e.aoOpenRows.length;/* If we are dealing with Ajax - do it here */
if(!e.oFeatures.bServerSide||_fnAjaxUpdate(e)){if(/* Check and see if we have an initial draw position from state saving */
"undefined"!=typeof e.iInitDisplayStart&&e.iInitDisplayStart!=-1&&(e._iDisplayStart=e.iInitDisplayStart>=e.fnRecordsDisplay()?0:e.iInitDisplayStart,e.iInitDisplayStart=-1,_fnCalculateEnd(e)),0!==e.aiDisplay.length){var l=e._iDisplayStart,u=e._iDisplayEnd;e.oFeatures.bServerSide&&(l=0,u=e.aoData.length);for(var f=l;f<u;f++){var d=e.aoData[e.aiDisplay[f]],p=d.nTr;/* Remove the old stripping classes and then add the new one */
if(0!==i){var g=e.asStripClasses[o%i];d._sRowStripe!=g&&($(p).removeClass(d._sRowStripe).addClass(g),d._sRowStripe=g)}/* If there is an open row - and it is attached to this parent - attach it on redraw */
if(/* Custom row callback function - might want to manipule the row */
"function"==typeof e.fnRowCallback&&(p=e.fnRowCallback(p,e.aoData[e.aiDisplay[f]]._aData,o,f),p||s||(alert("DataTables warning: A node was not returned by fnRowCallback"),s=!0)),n.push(p),o++,0!==r)for(var c=0;c<r;c++)p==e.aoOpenRows[c].nParent&&n.push(e.aoOpenRows[c].nTr)}}else{/* Table is empty - create a row with an empty message in it */
n[0]=document.createElement("tr"),"undefined"!=typeof e.asStripClasses[0]&&(n[0].className=e.asStripClasses[0]);var h=document.createElement("td");h.setAttribute("valign","top"),h.colSpan=e.aoColumns.length,h.className=e.oClasses.sRowEmpty,h.innerHTML=e.oLanguage.sZeroRecords,n[o].appendChild(h)}/* Callback the header and footer custom funcation if there is one */
"function"==typeof e.fnHeaderCallback&&e.fnHeaderCallback($("thead:eq(0)>tr",e.nTable)[0],_fnGetDataMaster(e),e._iDisplayStart,e.fnDisplayEnd(),e.aiDisplay),"function"==typeof e.fnFooterCallback&&e.fnFooterCallback($("tfoot:eq(0)>tr",e.nTable)[0],_fnGetDataMaster(e),e._iDisplayStart,e.fnDisplayEnd(),e.aiDisplay);/* 
			 * Need to remove any old row from the display - note we can't just empty the tbody using
			 * $().html('') since this will unbind the jQuery event handlers (even although the node 
			 * still exists!) - equally we can't use innerHTML, since IE throws an exception.
			 */
var _=e.nTable.getElementsByTagName("tbody");if(_[0]){var S=_[0].childNodes;for(a=S.length-1;a>=0;a--)S[a].parentNode.removeChild(S[a]);/* Put the draw table into the dom */
for(a=0,t=n.length;a<t;a++)_[0].appendChild(n[a])}/* Call all required callback functions for the end of a draw */
for(a=0,t=e.aoDrawCallback.length;a<t;a++)e.aoDrawCallback[a].fn(e);/* Draw is complete, sorting and filtering must be as well */
e.bSorted=!1,e.bFiltered=!1,/* Perform certain DOM operations after the table has been drawn for the first time */
"undefined"==typeof e._bInitComplete&&(e._bInitComplete=!0,/* Set an absolute width for the table such that pagination doesn't
				 * cause the table to resize
				 */
e.oFeatures.bAutoWidth&&0!==e.nTable.offsetWidth&&(e.nTable.style.width=e.nTable.offsetWidth+"px"))}}/*
		 * Function: _fnReDraw
		 * Purpose:  Redraw the table - taking account of the various features which are enabled
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnReDraw(e){e.oFeatures.bSort?/* Sorting will refilter and draw for us */
_fnSort(e,e.oPreviousSearch):e.oFeatures.bFilter?/* Filtering will redraw for us */
_fnFilterComplete(e,e.oPreviousSearch):(_fnCalculateEnd(e),_fnDraw(e))}/*
		 * Function: _fnAjaxUpdate
		 * Purpose:  Update the table using an Ajax call
		 * Returns:  bool: block the table drawing or not
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnAjaxUpdate(e){if(e.bAjaxDataGet){_fnProcessingDisplay(e,!0);var a,t=e.aoColumns.length,n=[];/* Filtering */
if(/* Paging and general */
e.iServerDraw++,n.push({name:"sEcho",value:e.iServerDraw}),n.push({name:"iColumns",value:t}),n.push({name:"sColumns",value:_fnColumnOrdering(e)}),n.push({name:"iDisplayStart",value:e._iDisplayStart}),n.push({name:"iDisplayLength",value:e.oFeatures.bPaginate!==!1?e._iDisplayLength:-1}),e.oFeatures.bFilter!==!1)for(n.push({name:"sSearch",value:e.oPreviousSearch.sSearch}),n.push({name:"bEscapeRegex",value:e.oPreviousSearch.bEscapeRegex}),a=0;a<t;a++)n.push({name:"sSearch_"+a,value:e.aoPreSearchCols[a].sSearch}),n.push({name:"bEscapeRegex_"+a,value:e.aoPreSearchCols[a].bEscapeRegex}),n.push({name:"bSearchable_"+a,value:e.aoColumns[a].bSearchable});/* Sorting */
if(e.oFeatures.bSort!==!1){var o=null!==e.aaSortingFixed?e.aaSortingFixed.length:0,s=e.aaSorting.length;for(n.push({name:"iSortingCols",value:o+s}),a=0;a<o;a++)n.push({name:"iSortCol_"+a,value:e.aaSortingFixed[a][0]}),n.push({name:"sSortDir_"+a,value:e.aaSortingFixed[a][1]});for(a=0;a<s;a++)n.push({name:"iSortCol_"+(a+o),value:e.aaSorting[a][0]}),n.push({name:"sSortDir_"+(a+o),value:e.aaSorting[a][1]});for(a=0;a<t;a++)n.push({name:"bSortable_"+a,value:e.aoColumns[a].bSortable})}return e.fnServerData(e.sAjaxSource,n,function(a){_fnAjaxUpdateDraw(e,a)}),!1}return!0}/*
		 * Function: _fnAjaxUpdateDraw
		 * Purpose:  Data the data from the server (nuking the old) and redraw the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           object:json - json data return from the server.
		 *             The following must be defined:
		 *               iTotalRecords, iTotalDisplayRecords, aaData
		 *             The following may be defined:
		 *               sColumns
		 */
function _fnAjaxUpdateDraw(e,a){if("undefined"!=typeof a.sEcho){/* Protect against old returns over-writing a new one. Possible when you get
				 * very fast interaction, and later queires are completed much faster
				 */
if(1*a.sEcho<e.iServerDraw)return;e.iServerDraw=1*a.sEcho}_fnClearTable(e),e._iRecordsTotal=a.iTotalRecords,e._iRecordsDisplay=a.iTotalDisplayRecords;/* Determine if reordering is required */
var t=_fnColumnOrdering(e),n="undefined"!=typeof a.sColumns&&""!==t&&a.sColumns!=t;if(n)var o=_fnReOrderIndex(e,a.sColumns);for(var s=0,i=a.aaData.length;s<i;s++)if(n){for(var r=[],l=0,u=e.aoColumns.length;l<u;l++)r.push(a.aaData[s][o[l]]);_fnAddData(e,r)}else/* No re-order required, sever got it "right" - just straight add */
_fnAddData(e,a.aaData[s]);e.aiDisplay=e.aiDisplayMaster.slice(),e.bAjaxDataGet=!1,_fnDraw(e),e.bAjaxDataGet=!0,_fnProcessingDisplay(e,!1)}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Options (features) HTML
		 */
/*
		 * Function: _fnAddOptionsHtml
		 * Purpose:  Add the options to the page HTML for the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnAddOptionsHtml(e){/*
			 * Create a temporary, empty, div which we can later on replace with what we have generated
			 * we do it this way to rendering the 'options' html offline - speed :-)
			 */
var a=document.createElement("div");e.nTable.parentNode.insertBefore(a,e.nTable);/* 
			 * All DataTables are wrapped in a div - this is not currently optional - backwards 
			 * compatability. It can be removed if you don't want it.
			 */
var t=document.createElement("div");t.className=e.oClasses.sWrapper,""!==e.sTableId&&t.setAttribute("id",e.sTableId+"_wrapper");/* Track where we want to insert the option */
var n=t,o=e.sDom.replace("H","fg-toolbar ui-widget-header ui-corner-tl ui-corner-tr ui-helper-clearfix");o=o.replace("F","fg-toolbar ui-widget-header ui-corner-bl ui-corner-br ui-helper-clearfix");for(var s,i,r,l,u,f,d,p=o.split(""),g=0;g<p.length;g++){if(i=0,r=p[g],"<"==r){if(/* New container div */
l=document.createElement("div"),/* Check to see if we should append a class name to the container */
u=p[g+1],"'"==u||'"'==u){for(f="",d=2;p[g+d]!=u;)f+=p[g+d],d++;l.className=f,g+=d}n.appendChild(l),n=l}else if(">"==r)/* End container div */
n=n.parentNode;else if("l"==r&&e.oFeatures.bPaginate&&e.oFeatures.bLengthChange)/* Length */
s=_fnFeatureHtmlLength(e),i=1;else if("f"==r&&e.oFeatures.bFilter)/* Filter */
s=_fnFeatureHtmlFilter(e),i=1;else if("r"==r&&e.oFeatures.bProcessing)/* pRocessing */
s=_fnFeatureHtmlProcessing(e),/* EllisLab edit - I hard coded the id rather than writing a new node
					*/
i=0;else if("t"==r)/* Table */
s=e.nTable,i=1;else if("i"==r&&e.oFeatures.bInfo)/* Info */
s=_fnFeatureHtmlInfo(e),i=1;else if("p"==r&&e.oFeatures.bPaginate)/* Pagination */
s=_fnFeatureHtmlPaginate(e),/* EllisLab edit - I hard coded it
					*/
i=0;else if(0!==_oExt.aoFeatures.length)for(var c=_oExt.aoFeatures,h=0,_=c.length;h<_;h++)if(r==c[h].cFeature){s=c[h].fnInit(e),s&&(i=1);break}/* Add to the 2D features array */
1==i&&("object"!=typeof e.aanFeatures[r]&&(e.aanFeatures[r]=[]),e.aanFeatures[r].push(s),n.appendChild(s))}/* Built our DOM structure - replace the holding div with what we want */
a.parentNode.replaceChild(t,a)}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Feature: Filtering
		 */
/*
		 * Function: _fnFeatureHtmlFilter
		 * Purpose:  Generate the node required for filtering text
		 * Returns:  node
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnFeatureHtmlFilter(e){var a=document.createElement("div");""!==e.sTableId&&"undefined"==typeof e.aanFeatures.f&&a.setAttribute("id",e.sTableId+"_filter"),a.className=e.oClasses.sFilter;var t=""===e.oLanguage.sSearch?"":" ";a.innerHTML=e.oLanguage.sSearch+t+'<input type="text" />';var n=$("input",a);return n.val(e.oPreviousSearch.sSearch.replace('"',"&quot;")),n.keyup(function(a){for(var t=e.aanFeatures.f,n=0,o=t.length;n<o;n++)t[n]!=this.parentNode&&$("input",t[n]).val(this.value);/* Now do the filter */
_fnFilterComplete(e,{sSearch:this.value,bEscapeRegex:e.oPreviousSearch.bEscapeRegex})}),n.keypress(function(e){/* Prevent default */
if(13==e.keyCode)return!1}),a}/*
		 * Function: _fnFilterComplete
		 * Purpose:  Filter the table using both the global filter and column based filtering
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           object:oSearch: search information
		 *           int:iForce - optional - force a research of the master array (1) or not (undefined or 0)
		 */
function _fnFilterComplete(e,a,t){/* Filter on everything */
_fnFilter(e,a.sSearch,t,a.bEscapeRegex);/* Now do the individual column filter */
for(var n=0;n<e.aoPreSearchCols.length;n++)_fnFilterColumn(e,e.aoPreSearchCols[n].sSearch,n,e.aoPreSearchCols[n].bEscapeRegex);/* Custom filtering */
0!==_oExt.afnFiltering.length&&_fnFilterCustom(e),/* Tell the draw function we have been filtering */
e.bFiltered=!0,/* Redraw the table */
e._iDisplayStart=0,_fnCalculateEnd(e),_fnDraw(e),/* Rebuild search array 'offline' */
_fnBuildSearchArray(e,0)}/*
		 * Function: _fnFilterCustom
		 * Purpose:  Apply custom filtering functions
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnFilterCustom(e){for(var a=_oExt.afnFiltering,t=0,n=a.length;t<n;t++)for(var o=0,s=0,i=e.aiDisplay.length;s<i;s++){var r=e.aiDisplay[s-o];/* Check if we should use this row based on the filtering function */
a[t](e,e.aoData[r]._aData,r)||(e.aiDisplay.splice(s-o,1),o++)}}/*
		 * Function: _fnFilterColumn
		 * Purpose:  Filter the table on a per-column basis
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           string:sInput - string to filter on
		 *           int:iColumn - column to filter
		 *           bool:bEscapeRegex - escape regex or not
		 */
function _fnFilterColumn(e,a,t,n){if(""!==a)for(var o=0,s=n?_fnEscapeRegex(a):a,i=new RegExp(s,"i"),r=e.aiDisplay.length-1;r>=0;r--){var l=_fnDataToSearch(e.aoData[e.aiDisplay[r]]._aData[t],e.aoColumns[t].sType);i.test(l)||(e.aiDisplay.splice(r,1),o++)}}/*
		 * Function: _fnFilter
		 * Purpose:  Filter the data table based on user input and draw the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           string:sInput - string to filter on
		 *           int:iForce - optional - force a research of the master array (1) or not (undefined or 0)
		 *           bool:bEscapeRegex - escape regex or not
		 */
function _fnFilter(e,a,t,n){var o;/* Check if we are forcing or not - optional parameter */
"undefined"!=typeof t&&null!==t||(t=0),/* Need to take account of custom filtering functions always */
0!==_oExt.afnFiltering.length&&(t=1);/* Generate the regular expression to use. Something along the lines of:
			 * ^(?=.*?\bone\b)(?=.*?\btwo\b)(?=.*?\bthree\b).*$
			 */
var s=n?_fnEscapeRegex(a).split(" "):a.split(" "),i="^(?=.*?"+s.join(")(?=.*?")+").*$",r=new RegExp(i,"i");/* case insensitive */
/*
			 * If the input is blank - we want the full data set
			 */
if(a.length<=0)e.aiDisplay.splice(0,e.aiDisplay.length),e.aiDisplay=e.aiDisplayMaster.slice();else/*
				 * We are starting a new search or the new search string is smaller 
				 * then the old one (i.e. delete). Search from the master array
			 	 */
if(e.aiDisplay.length==e.aiDisplayMaster.length||e.oPreviousSearch.sSearch.length>a.length||1==t||0!==a.indexOf(e.oPreviousSearch.sSearch))/* Search through all records to populate the search array
					 * The the oSettings.aiDisplayMaster and asDataSearch arrays have 1 to 1 
					 * mapping
					 */
for(/* Nuke the old display array - we are going to rebuild it */
e.aiDisplay.splice(0,e.aiDisplay.length),/* Force a rebuild of the search array */
_fnBuildSearchArray(e,1),o=0;o<e.aiDisplayMaster.length;o++)r.test(e.asDataSearch[o])&&e.aiDisplay.push(e.aiDisplayMaster[o]);else{/* Using old search array - refine it - do it this way for speed
			  	 * Don't have to search the whole master array again
			 		 */
var l=0;/* Search the current results */
for(o=0;o<e.asDataSearch.length;o++)r.test(e.asDataSearch[o])||(e.aiDisplay.splice(o-l,1),l++)}e.oPreviousSearch.sSearch=a,e.oPreviousSearch.bEscapeRegex=n}/*
		 * Function: _fnBuildSearchArray
		 * Purpose:  Create an array which can be quickly search through
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           int:iMaster - use the master data array - optional
		 */
function _fnBuildSearchArray(e,a){/* Clear out the old data */
e.asDataSearch.splice(0,e.asDataSearch.length);for(var t="undefined"!=typeof a&&1==a?e.aiDisplayMaster:e.aiDisplay,n=0,o=t.length;n<o;n++){e.asDataSearch[n]="";for(var s=0,i=e.aoColumns.length;s<i;s++)if(e.aoColumns[s].bSearchable){var r=e.aoData[t[n]]._aData[s];e.asDataSearch[n]+=_fnDataToSearch(r,e.aoColumns[s].sType)+" "}}}/*
		 * Function: _fnDataToSearch
		 * Purpose:  Convert raw data into something that the user can search on
		 * Returns:  string: - search string
		 * Inputs:   string:sData - data to be modified
		 *           string:sType - data type
		 */
function _fnDataToSearch(e,a){return"function"==typeof _oExt.ofnSearch[a]?_oExt.ofnSearch[a](e):"html"==a?e.replace(/\n/g," ").replace(/<.*?>/g,""):"string"==typeof e?e.replace(/\n/g," "):e}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Feature: Sorting
		 */
/*
	 	 * Function: _fnSort
		 * Purpose:  Change the order of the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           bool:bApplyClasses - optional - should we apply classes or not
		 * Notes:    We always sort the master array and then apply a filter again
		 *   if it is needed. This probably isn't optimal - but atm I can't think
		 *   of any other way which is (each has disadvantages). we want to sort aiDisplayMaster - 
		 *   but according to aoData[]._aData
		 */
function _fnSort(oSettings,bApplyClasses){var aaSort=[],oSort=_oExt.oSort,aoData=oSettings.aoData,iDataSort,iDataType,i,j,jLen;/* No sorting required if server-side or no sorting array */
if(!oSettings.oFeatures.bServerSide&&(0!==oSettings.aaSorting.length||null!==oSettings.aaSortingFixed)){/* If there is a sorting data type, and a fuction belonging to it, then we need to
				 * get the data from the developer's function and apply it for this column
				 */
for(aaSort=null!==oSettings.aaSortingFixed?oSettings.aaSortingFixed.concat(oSettings.aaSorting):oSettings.aaSorting.slice(),i=0;i<aaSort.length;i++){var iColumn=aaSort[i][0],sDataType=oSettings.aoColumns[iColumn].sSortDataType;if("undefined"!=typeof _oExt.afnSortData[sDataType]){var iCorrector=0,aData=_oExt.afnSortData[sDataType](oSettings,iColumn);for(j=0,jLen=aoData.length;j<jLen;j++)null!==aoData[j]&&(aoData[j]._aData[iColumn]=aData[iCorrector],iCorrector++)}}/* DataTables offers two different methods for doing the 2D array sorting over multiple
				 * columns. The first is to construct a function dynamically, and then evaluate and run
				 * the function, while the second has no need for evalulation, but is a little bit slower.
				 * This is used for environments which do not allow eval() for code execuation such as AIR
				 */
if(window.runtime){/*
					 * Non-eval() sorting (AIR and other environments which doesn't allow code in eval()
					 * Note that for reasonable sized data sets this method is around 1.5 times slower than
					 * the eval above (hence why it is not used all the time). Oddly enough, it is ever so
					 * slightly faster for very small sets (presumably the eval has overhead).
					 *   Single column (1083 records) - eval: 32mS   AIR: 38mS
					 *   Two columns (1083 records) -   eval: 55mS   AIR: 66mS
					 */
/* Build a cached array so the sort doesn't have to process this stuff on every call */
var aAirSort=[],iLen=aaSort.length;for(i=0;i<iLen;i++)iDataSort=oSettings.aoColumns[aaSort[i][0]].iDataSort,aAirSort.push([iDataSort,oSettings.aoColumns[iDataSort].sType+"-"+aaSort[i][1]]);oSettings.aiDisplayMaster.sort(function(e,a){for(var t,n=0;n<iLen;n++)if(t=oSort[aAirSort[n][1]](aoData[e]._aData[aAirSort[n][0]],aoData[a]._aData[aAirSort[n][0]]),0!==t)return t;return 0})}else{/* Dynamically created sorting function. Based on the information that we have, we can
					 * create a sorting function as if it were specifically written for this sort. Here we
					 * want to build a function something like (for two column sorting):
					 *  fnLocalSorting = function(a,b){
					 *  	var iTest;
					 *  	iTest = oSort['string-asc']('data11', 'data12');
					 *  	if (iTest === 0)
					 *  		iTest = oSort['numeric-desc']('data21', 'data22');
					 *  		if (iTest === 0)
					 *  			return oSort['numeric-desc'](1,2);
					 *  	return iTest;
					 *  }
					 * So basically we have a test for each column, and if that column matches, test the
					 * next one. If all columns match, then we use a numeric sort on the position the two
					 * row have in the original data array in order to provide a stable sort.
					 */
var fnLocalSorting,sDynamicSort="fnLocalSorting = function(a,b){var iTest;";for(i=0;i<aaSort.length-1;i++)iDataSort=oSettings.aoColumns[aaSort[i][0]].iDataSort,iDataType=oSettings.aoColumns[iDataSort].sType,sDynamicSort+="iTest = oSort['"+iDataType+"-"+aaSort[i][1]+"']( aoData[a]._aData["+iDataSort+"], aoData[b]._aData["+iDataSort+"] ); if ( iTest === 0 )";iDataSort=oSettings.aoColumns[aaSort[aaSort.length-1][0]].iDataSort,iDataType=oSettings.aoColumns[iDataSort].sType,sDynamicSort+="iTest = oSort['"+iDataType+"-"+aaSort[aaSort.length-1][1]+"']( aoData[a]._aData["+iDataSort+"], aoData[b]._aData["+iDataSort+"] );if (iTest===0) return oSort['numeric-"+aaSort[aaSort.length-1][1]+"'](a, b); return iTest;}",/* The eval has to be done to a variable for IE */
eval(sDynamicSort),oSettings.aiDisplayMaster.sort(fnLocalSorting)}}/* Alter the sorting classes to take account of the changes */
("undefined"==typeof bApplyClasses||bApplyClasses)&&_fnSortingClasses(oSettings),/* Tell the draw function that we have sorted the data */
oSettings.bSorted=!0,/* Copy the master data into the draw array and re-draw */
oSettings.oFeatures.bFilter?/* _fnFilter() will redraw the table for us */
_fnFilterComplete(oSettings,oSettings.oPreviousSearch,1):(oSettings.aiDisplay=oSettings.aiDisplayMaster.slice(),oSettings._iDisplayStart=0,/* reset display back to page 0 */
_fnCalculateEnd(oSettings),_fnDraw(oSettings))}/*
		 * Function: _fnSortAttachListener
		 * Purpose:  Attach a sort handler (click) to a node
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           node:nNode - node to attach the handler to
		 *           int:iDataIndex - column sorting index
		 *           function:fnCallback - callback function - optional
		 */
function _fnSortAttachListener(e,a,t,n){$(a).click(function(a){/* If the column is not sortable - don't to anything */
if(e.aoColumns[t].bSortable!==!1){/*
				 * This is a little bit odd I admit... I declare a temporary function inside the scope of
				 * _fnDrawHead and the click handler in order that the code presented here can be used 
				 * twice - once for when bProcessing is enabled, and another time for when it is 
				 * disabled, as we need to perform slightly different actions.
				 *   Basically the issue here is that the Javascript engine in modern browsers don't 
				 * appear to allow the rendering engine to update the display while it is still excuting
				 * it's thread (well - it does but only after long intervals). This means that the 
				 * 'processing' display doesn't appear for a table sort. To break the js thread up a bit
				 * I force an execution break by using setTimeout - but this breaks the expected 
				 * thread continuation for the end-developer's point of view (their code would execute
				 * too early), so we on;y do it when we absolutely have to.
				 */
var o=function(){var n,o;/* If the shift key is pressed then we are multipe column sorting */
if(a.shiftKey){for(var s=!1,i=0;i<e.aaSorting.length;i++)if(e.aaSorting[i][0]==t){s=!0,n=e.aaSorting[i][0],o=e.aaSorting[i][2]+1,"undefined"==typeof e.aoColumns[n].asSorting[o]?/* Reached the end of the sorting options, remove from multi-col sort */
e.aaSorting.splice(i,1):(/* Move onto next sorting direction */
e.aaSorting[i][1]=e.aoColumns[n].asSorting[o],e.aaSorting[i][2]=o);break}/* No sort yet - add it in */
s===!1&&e.aaSorting.push([t,e.aoColumns[t].asSorting[0],0])}else/* If no shift key then single column sort */
1==e.aaSorting.length&&e.aaSorting[0][0]==t?(n=e.aaSorting[0][0],o=e.aaSorting[0][2]+1,"undefined"==typeof e.aoColumns[n].asSorting[o]&&(o=0),e.aaSorting[0][1]=e.aoColumns[n].asSorting[o],e.aaSorting[0][2]=o):(e.aaSorting.splice(0,e.aaSorting.length),e.aaSorting.push([t,e.aoColumns[t].asSorting[0],0]));/* Run the sort */
_fnSort(e)};/* /fnInnerSorting */
e.oFeatures.bProcessing?(_fnProcessingDisplay(e,!0),setTimeout(function(){o(),e.oFeatures.bServerSide||_fnProcessingDisplay(e,!1)},0)):o(),/* Call the user specified callback function - used for async user interaction */
"function"==typeof n&&n(e)}})}/*
		 * Function: _fnSortingClasses
		 * Purpose:  Set the sortting classes on the header
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 * Notes:    It is safe to call this function when bSort is false
		 */
function _fnSortingClasses(e){var a,t,n,o,s,i,r=e.aoColumns.length,l=e.oClasses;for(a=0;a<r;a++)e.aoColumns[a].bSortable&&$(e.aoColumns[a].nTh).removeClass(l.sSortAsc+" "+l.sSortDesc+" "+e.aoColumns[a].sSortingClass);/* Apply the required classes to the header */
for(s=null!==e.aaSortingFixed?e.aaSortingFixed.concat(e.aaSorting):e.aaSorting.slice(),a=0;a<e.aoColumns.length;a++)if(e.aoColumns[a].bSortable){for(i=e.aoColumns[a].sSortingClass,o=-1,t=0;t<s.length;t++)if(s[t][0]==a){i="asc"==s[t][1]?l.sSortAsc:l.sSortDesc,o=t;break}if($(e.aoColumns[a].nTh).addClass(i),e.bJUI){/* jQuery UI uses extra markup */
var u=$("span",e.aoColumns[a].nTh);u.removeClass(l.sSortJUIAsc+" "+l.sSortJUIDesc+" "+l.sSortJUI+" "+l.sSortJUIAscAllowed+" "+l.sSortJUIDescAllowed);var f;f=o==-1?e.aoColumns[a].sSortingClassJUI:"asc"==s[o][1]?l.sSortJUIAsc:l.sSortJUIDesc,u.addClass(f)}}else/* No sorting on this column, so add the base class. This will have been assigned by
					 * _fnAddColumn
					 */
$(e.aoColumns[a].nTh).addClass(e.aoColumns[a].sSortingClass);if(/* 
			 * Apply the required classes to the table body
			 * Note that this is given as a feature switch since it can significantly slow down a sort
			 * on large data sets (adding and removing of classes is always slow at the best of times..)
			 * Further to this, note that this code is admitadly fairly ugly. It could be made a lot 
			 * simpiler using jQuery selectors and add/removeClass, but that is significantly slower
			 * (on the order of 5 times slower) - hence the direct DOM manipulation here.
			 */
i=l.sSortColumn,e.oFeatures.bSort&&e.oFeatures.bSortClasses){var d=_fnGetTdNodes(e);/* Remove the old classes */
if(d.length>=r)for(a=0;a<r;a++)if(d[a].className.indexOf(i+"1")!=-1)for(t=0,n=d.length/r;t<n;t++)d[r*t+a].className=d[r*t+a].className.replace(" "+i+"1","");else if(d[a].className.indexOf(i+"2")!=-1)for(t=0,n=d.length/r;t<n;t++)d[r*t+a].className=d[r*t+a].className.replace(" "+i+"2","");else if(d[a].className.indexOf(i+"3")!=-1)for(t=0,n=d.length/r;t<n;t++)d[r*t+a].className=d[r*t+a].className.replace(" "+i+"3","");/* Add the new classes to the table */
var p,g=1;for(a=0;a<s.length;a++){for(p=parseInt(s[a][0],10),t=0,n=d.length/r;t<n;t++)d[r*t+p].className+=" "+i+g;g<3&&g++}}}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Feature: Pagination. Note that most of the paging logic is done in 
		 * _oExt.oPagination
		 */
/*
		 * Function: _fnFeatureHtmlPaginate
		 * Purpose:  Generate the node required for default pagination
		 * Returns:  node
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnFeatureHtmlPaginate(e){
// EllisLab edit
var a=document.getElementById("filter_pagination");
//var nPaginate = document.createElement( 'div' );
/* Add a draw callback for the pagination on first instance, to update the paging display */
return a.className=e.oClasses.sPaging+e.sPaginationType,_oExt.oPagination[e.sPaginationType].fnInit(e,a,function(e){_fnCalculateEnd(e),_fnDraw(e)}),"undefined"==typeof e.aanFeatures.p&&e.aoDrawCallback.push({fn:function(e){_oExt.oPagination[e.sPaginationType].fnUpdate(e,function(e){_fnCalculateEnd(e),_fnDraw(e)})},sName:"pagination"}),a}/*
		 * Function: _fnPageChange
		 * Purpose:  Alter the display settings to change the page
		 * Returns:  bool:true - page has changed, false - no change (no effect) eg 'first' on page 1
		 * Inputs:   object:oSettings - dataTables settings object
		 *           string:sAction - paging action to take: "first", "previous", "next" or "last"
		 */
function _fnPageChange(e,a){var t=e._iDisplayStart;if("first"==a)e._iDisplayStart=0;else if("previous"==a)e._iDisplayStart=e._iDisplayLength>=0?e._iDisplayStart-e._iDisplayLength:0,/* Correct for underrun */
e._iDisplayStart<0&&(e._iDisplayStart=0);else if("next"==a)e._iDisplayLength>=0?/* Make sure we are not over running the display array */
e._iDisplayStart+e._iDisplayLength<e.fnRecordsDisplay()&&(e._iDisplayStart+=e._iDisplayLength):e._iDisplayStart=0;else if("last"==a)if(e._iDisplayLength>=0){var n=parseInt((e.fnRecordsDisplay()-1)/e._iDisplayLength,10)+1;e._iDisplayStart=(n-1)*e._iDisplayLength}else e._iDisplayStart=0;else alert("DataTables warning: unknown paging action: "+a);return t!=e._iDisplayStart}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Feature: HTML info
		 */
/*
		 * Function: _fnFeatureHtmlInfo
		 * Purpose:  Generate the node required for the info display
		 * Returns:  node
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnFeatureHtmlInfo(e){var a=document.createElement("div");/* Actions that are to be taken once only for this feature */
/* Add draw callback */
/* Add id */
return a.className=e.oClasses.sInfo,"undefined"==typeof e.aanFeatures.i&&(e.aoDrawCallback.push({fn:_fnUpdateInfo,sName:"information"}),""!==e.sTableId&&a.setAttribute("id",e.sTableId+"_info")),a}/*
		 * Function: _fnUpdateInfo
		 * Purpose:  Update the information elements in the display
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnUpdateInfo(e){/* Show information about the table */
if(e.oFeatures.bInfo&&0!==e.aanFeatures.i.length){var a=e.aanFeatures.i[0],t=1;0==e.fnDisplayEnd()&&(t=0),0===e.fnRecordsDisplay()&&e.fnRecordsDisplay()==e.fnRecordsTotal()?/* Empty record set */
a.innerHTML=e.oLanguage.sInfoEmpty+e.oLanguage.sInfoPostFix:0===e.fnRecordsDisplay()?/* Rmpty record set after filtering */
a.innerHTML=e.oLanguage.sInfoEmpty+" "+e.oLanguage.sInfoFiltered.replace("_MAX_",e.fnRecordsTotal())+e.oLanguage.sInfoPostFix:e.fnRecordsDisplay()==e.fnRecordsTotal()?/* Normal record set */
a.innerHTML=e.oLanguage.sInfo.replace("_START_",e._iDisplayStart+t).replace("_END_",e.fnDisplayEnd()).replace("_TOTAL_",e.fnRecordsDisplay())+e.oLanguage.sInfoPostFix:/* Record set after filtering */
a.innerHTML=e.oLanguage.sInfo.replace("_START_",e._iDisplayStart+t).replace("_END_",e.fnDisplayEnd()).replace("_TOTAL_",e.fnRecordsDisplay())+" "+e.oLanguage.sInfoFiltered.replace("_MAX_",e.fnRecordsTotal())+e.oLanguage.sInfoPostFix;/* No point in recalculating for the other info elements, just copy the first one in */
var n=e.aanFeatures.i;if(n.length>1)for(var o=a.innerHTML,s=1,i=n.length;s<i;s++)n[s].innerHTML=o}}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Feature: Length change
		 */
/*
		 * Function: _fnFeatureHtmlLength
		 * Purpose:  Generate the node required for user display length changing
		 * Returns:  node
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnFeatureHtmlLength(e){/* This can be overruled by not using the _MENU_ var/macro in the language variable */
var a=""===e.sTableId?"":'name="'+e.sTableId+'_length"',t='<select size="1" '+a+'><option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="100">100</option></select>',n=document.createElement("div");/*
			 * Set the length to the current display length - thanks to Andrea Pavlovic for this fix,
			 * and Stefan Skopnik for fixing the fix!
			 */
return""!==e.sTableId&&"undefined"==typeof e.aanFeatures.l&&n.setAttribute("id",e.sTableId+"_length"),n.className=e.oClasses.sLength,n.innerHTML=e.oLanguage.sLengthMenu.replace("_MENU_",t),$('select option[value="'+e._iDisplayLength+'"]',n).attr("selected",!0),$("select",n).change(function(a){for(var t=$(this).val(),n=e.aanFeatures.l,o=0,s=n.length;o<s;o++)n[o]!=this.parentNode&&$("select",n[o]).val(t);/* Redraw the table */
e._iDisplayLength=parseInt(t,10),_fnCalculateEnd(e),/* If we have space to show extra rows (backing up from the end point - then do so */
e._iDisplayEnd==e.aiDisplay.length&&(e._iDisplayStart=e._iDisplayEnd-e._iDisplayLength,e._iDisplayStart<0&&(e._iDisplayStart=0)),e._iDisplayLength==-1&&(e._iDisplayStart=0),_fnDraw(e)}),n}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Feature: Processing incidator
		 */
/*
		 * Function: _fnFeatureHtmlProcessing
		 * Purpose:  Generate the node required for the processing node
		 * Returns:  node
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnFeatureHtmlProcessing(e){
// EllisLab edit
var a=document.getElementById("filter_ajax_indicator");return a;var a}/*
		 * Function: _fnProcessingDisplay
		 * Purpose:  Display or hide the processing indicator
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           bool:
		 *   true - show the processing indicator
		 *   false - don't show
		 */
function _fnProcessingDisplay(e,a){if(e.oFeatures.bProcessing)//oSettings.aanFeatures.r;
for(var t=document.getElementById("filter_ajax_indicator"),n=0,o=t.length;n<o;n++)t[n].style.visibility=a?"visible":"hidden"}/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Support functions
		 */
/*
		 * Function: _fnVisibleToColumnIndex
		 * Purpose:  Covert the index of a visible column to the index in the data array (take account
		 *   of hidden columns)
		 * Returns:  int:i - the data index
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnVisibleToColumnIndex(e,a){for(var t=-1,n=0;n<e.aoColumns.length;n++)if(e.aoColumns[n].bVisible===!0&&t++,t==a)return n;return null}/*
		 * Function: _fnColumnIndexToVisible
		 * Purpose:  Covert the index of an index in the data array and convert it to the visible
		 *   column index (take account of hidden columns)
		 * Returns:  int:i - the data index
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnColumnIndexToVisible(e,a){for(var t=-1,n=0;n<e.aoColumns.length;n++)if(e.aoColumns[n].bVisible===!0&&t++,n==a)return e.aoColumns[n].bVisible===!0?t:null;return null}/*
		 * Function: _fnNodeToDataIndex
		 * Purpose:  Take a TR element and convert it to an index in aoData
		 * Returns:  int:i - index if found, null if not
		 * Inputs:   object:s - dataTables settings object
		 *           node:n - the TR element to find
		 */
function _fnNodeToDataIndex(e,a){for(var t=0,n=e.aoData.length;t<n;t++)if(null!==e.aoData[t]&&e.aoData[t].nTr==a)return t;return null}/*
		 * Function: _fnVisbleColumns
		 * Purpose:  Get the number of visible columns
		 * Returns:  int:i - the number of visible columns
		 * Inputs:   object:oS - dataTables settings object
		 */
function _fnVisbleColumns(e){for(var a=0,t=0;t<e.aoColumns.length;t++)e.aoColumns[t].bVisible===!0&&a++;return a}/*
		 * Function: _fnCalculateEnd
		 * Purpose:  Rcalculate the end point based on the start point
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnCalculateEnd(e){e.oFeatures.bPaginate===!1?e._iDisplayEnd=e.aiDisplay.length:/* Set the end point of the display - based on how many elements there are
				 * still to display
				 */
e._iDisplayStart+e._iDisplayLength>e.aiDisplay.length||e._iDisplayLength==-1?e._iDisplayEnd=e.aiDisplay.length:e._iDisplayEnd=e._iDisplayStart+e._iDisplayLength}/*
		 * Function: _fnConvertToWidth
		 * Purpose:  Convert a CSS unit width to pixels (e.g. 2em)
		 * Returns:  int:iWidth - width in pixels
		 * Inputs:   string:sWidth - width to be converted
		 *           node:nParent - parent to get the with for (required for
		 *             relative widths) - optional
		 */
function _fnConvertToWidth(e,a){if(!e||null===e||""===e)return 0;"undefined"==typeof a&&(a=document.getElementsByTagName("body")[0]);var t,n=document.createElement("div");return n.style.width=e,a.appendChild(n),t=n.offsetWidth,a.removeChild(n),t}/*
		 * Function: _fnCalculateColumnWidths
		 * Purpose:  Calculate the width of columns for the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnCalculateColumnWidths(e){var a,t,n=e.nTable.offsetWidth,o=0,s=0,i=e.aoColumns.length,r=$("thead:eq(0)>th",e.nTable);/* Convert any user input sizes into pixel sizes */
for(t=0;t<i;t++)e.aoColumns[t].bVisible&&(s++,null!==e.aoColumns[t].sWidth&&(a=_fnConvertToWidth(e.aoColumns[t].sWidth,e.nTable.parentNode),/* Total up the user defined widths for later calculations */
o+=a,e.aoColumns[t].sWidth=a+"px"));/* If the number of columns in the DOM equals the number that we
			 * have to process in dataTables, then we can use the offsets that are
			 * created by the web-browser. No custom sizes can be set in order for
			 * this to happen
			 */
if(i==r.length&&0===o&&s==i)for(t=0;t<e.aoColumns.length;t++)e.aoColumns[t].sWidth=r[t].offsetWidth+"px";else{/* Otherwise we are going to have to do some calculations to get
				 * the width of each column. Construct a 1 row table with the maximum
				 * string sizes in the data, and any user defined widths
				 */
var l=e.nTable.cloneNode(!1);l.setAttribute("id","");var u='<table class="'+l.className+'">',f="<tr>",d="<tr>";/* Construct a tempory table which we will inject (invisibly) into
				 * the dom - to let the browser do all the hard word
				 */
for(t=0;t<i;t++)if(e.aoColumns[t].bVisible)if(f+="<th>"+e.aoColumns[t].sTitle+"</th>",null!==e.aoColumns[t].sWidth){var p="";null!==e.aoColumns[t].sWidth&&(p=' style="width:'+e.aoColumns[t].sWidth+';"'),d+="<td"+p+' tag_index="'+t+'">'+fnGetMaxLenString(e,t)+"</td>"}else d+='<td tag_index="'+t+'">'+fnGetMaxLenString(e,t)+"</td>";f+="</tr>",d+="</tr>",/* Create the tmp table node (thank you jQuery) */
l=$(u+f+d+"</table>")[0],l.style.width=n+"px",l.style.visibility="hidden",l.style.position="absolute",/* Try to aviod scroll bar */
e.nTable.parentNode.appendChild(l);var g,c=$("tr:eq(1)>td",l);/* Gather in the browser calculated widths for the rows */
for(t=0;t<c.length;t++){g=c[t].getAttribute("tag_index");var h=$("td",l).eq(t).width(),_=e.aoColumns[t].sWidth?e.aoColumns[t].sWidth.slice(0,-2):0;e.aoColumns[g].sWidth=Math.max(h,_)+"px"}e.nTable.parentNode.removeChild(l)}}/*
		 * Function: fnGetMaxLenString
		 * Purpose:  Get the maximum strlen for each data column
		 * Returns:  string: - max strlens for each column
		 * Inputs:   object:oSettings - dataTables settings object
		 *           int:iCol - column of interest
		 */
function fnGetMaxLenString(e,a){for(var t=0,n=-1,o=0;o<e.aoData.length;o++)e.aoData[o]._aData[a].length>t&&(t=e.aoData[o]._aData[a].length,n=o);return n>=0?e.aoData[n]._aData[a]:""}/*
		 * Function: _fnArrayCmp
		 * Purpose:  Compare two arrays
		 * Returns:  0 if match, 1 if length is different, 2 if no match
		 * Inputs:   array:aArray1 - first array
		 *           array:aArray2 - second array
		 */
function _fnArrayCmp(e,a){if(e.length!=a.length)return 1;for(var t=0;t<e.length;t++)if(e[t]!=a[t])return 2;return 0}/*
		 * Function: _fnDetectType
		 * Purpose:  Get the sort type based on an input string
		 * Returns:  string: - type (defaults to 'string' if no type can be detected)
		 * Inputs:   string:sData - data we wish to know the type of
		 * Notes:    This function makes use of the DataTables plugin objct _oExt 
		 *   (.aTypes) such that new types can easily be added.
		 */
function _fnDetectType(e){for(var a=_oExt.aTypes,t=a.length,n=0;n<t;n++){var o=a[n](e);if(null!==o)return o}return"string"}/*
		 * Function: _fnSettingsFromNode
		 * Purpose:  Return the settings object for a particular table
		 * Returns:  object: Settings object - or null if not found
		 * Inputs:   node:nTable - table we are using as a dataTable
		 */
function _fnSettingsFromNode(e){for(var a=0;a<_aoSettings.length;a++)if(_aoSettings[a].nTable==e)return _aoSettings[a];return null}/*
		 * Function: _fnGetDataMaster
		 * Purpose:  Return an array with the full table data
		 * Returns:  array array:aData - Master data array
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnGetDataMaster(e){for(var a=[],t=e.aoData.length,n=0;n<t;n++)null===e.aoData[n]?a.push(null):a.push(e.aoData[n]._aData);return a}/*
		 * Function: _fnGetTrNodes
		 * Purpose:  Return an array with the TR nodes for the table
		 * Returns:  array: - TR array
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnGetTrNodes(e){for(var a=[],t=e.aoData.length,n=0;n<t;n++)null===e.aoData[n]?a.push(null):a.push(e.aoData[n].nTr);return a}/*
		 * Function: _fnGetTdNodes
		 * Purpose:  Return an array with the TD nodes for the table
		 * Returns:  array: - TD array
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnGetTdNodes(e){var a,t,n,o,s,i,r=_fnGetTrNodes(e),l=[],u=[];for(n=0,o=r.length;n<o;n++){for(l=[],s=0,i=r[n].childNodes.length;s<i;s++)a=r[n].childNodes[s],"TD"==a.nodeName&&l.push(a);for(t=0,s=0,i=e.aoColumns.length;s<i;s++)e.aoColumns[s].bVisible?u.push(l[s-t]):(u.push(e.aoData[n]._anHidden[s]),t++)}return u}/*
		 * Function: _fnEscapeRegex
		 * Purpose:  scape a string stuch that it can be used in a regular expression
		 * Returns:  string: - escaped string
		 * Inputs:   string:sVal - string to escape
		 */
function _fnEscapeRegex(e){var a=["/",".","*","+","?","|","(",")","[","]","{","}","\\","$","^"],t=new RegExp("(\\"+a.join("|\\")+")","g");return e.replace(t,"\\$1")}/*
		 * Function: _fnReOrderIndex
		 * Purpose:  Figure out how to reorder a display list
		 * Returns:  array int:aiReturn - index list for reordering
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnReOrderIndex(e,a){for(var t=a.split(","),n=[],o=0,s=e.aoColumns.length;o<s;o++)for(var i=0;i<s;i++)if(e.aoColumns[o].sName==t[i]){n.push(i);break}return n}/*
		 * Function: _fnColumnOrdering
		 * Purpose:  Get the column ordering that DataTables expects
		 * Returns:  string: - comma separated list of names
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnColumnOrdering(e){for(var a="",t=0,n=e.aoColumns.length;t<n;t++)a+=e.aoColumns[t].sName+",";return a.length==n?"":a.slice(0,-1)}/*
		 * Function: _fnClearTable
		 * Purpose:  Nuke the table
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnClearTable(e){e.aoData.length=0,e.aiDisplayMaster.length=0,e.aiDisplay.length=0,_fnCalculateEnd(e)}/*
		 * Function: _fnSaveState
		 * Purpose:  Save the state of a table in a cookie such that the page can be reloaded
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 */
function _fnSaveState(e){if(e.oFeatures.bStateSave){/* Store the interesting variables */
var a,t="{";for(t+='"iStart": '+e._iDisplayStart+",",t+='"iEnd": '+e._iDisplayEnd+",",t+='"iLength": '+e._iDisplayLength+",",t+='"sFilter": "'+e.oPreviousSearch.sSearch.replace('"','\\"')+'",',t+='"sFilterEsc": '+e.oPreviousSearch.bEscapeRegex+",",t+='"aaSorting": [ ',a=0;a<e.aaSorting.length;a++)t+="["+e.aaSorting[a][0]+",'"+e.aaSorting[a][1]+"'],";for(t=t.substring(0,t.length-1),t+="],",t+='"aaSearchCols": [ ',a=0;a<e.aoPreSearchCols.length;a++)t+="['"+e.aoPreSearchCols[a].sSearch.replace("'","'")+"',"+e.aoPreSearchCols[a].bEscapeRegex+"],";for(t=t.substring(0,t.length-1),t+="],",t+='"abVisCols": [ ',a=0;a<e.aoColumns.length;a++)t+=e.aoColumns[a].bVisible+",";t=t.substring(0,t.length-1),t+="]",t+="}",_fnCreateCookie("SpryMedia_DataTables_"+e.sInstance,t,e.iCookieDuration)}}/*
		 * Function: _fnLoadState
		 * Purpose:  Attempt to load a saved table state from a cookie
		 * Returns:  -
		 * Inputs:   object:oSettings - dataTables settings object
		 *           object:oInit - DataTables init object so we can override settings
		 */
function _fnLoadState(oSettings,oInit){if(oSettings.oFeatures.bStateSave){var oData,sData=_fnReadCookie("SpryMedia_DataTables_"+oSettings.sInstance);if(null!==sData&&""!==sData){/* Try/catch the JSON eval - if it is bad then we ignore it */
try{/* Use the JSON library for safety - if it is available */
/* DT 1.4.0 used single quotes for a string - JSON.parse doesn't allow this and throws
						 * an error. So for now we can do this. This can be removed in future it is just to
						 * allow the tranfrer to 1.4.1+ to occur
						 */
oData="object"==typeof JSON&&"function"==typeof JSON.parse?JSON.parse(sData.replace(/'/g,'"')):eval("("+sData+")")}catch(e){return}/* Column filtering - added in 1.5.0 beta 6 */
if(/* Restore key features */
oSettings._iDisplayStart=oData.iStart,oSettings.iInitDisplayStart=oData.iStart,oSettings._iDisplayEnd=oData.iEnd,oSettings._iDisplayLength=oData.iLength,oSettings.oPreviousSearch.sSearch=oData.sFilter,oSettings.aaSorting=oData.aaSorting.slice(),oSettings.saved_aaSorting=oData.aaSorting.slice(),/* Search filtering - global reference added in 1.4.1 */
"undefined"!=typeof oData.sFilterEsc&&(oSettings.oPreviousSearch.bEscapeRegex=oData.sFilterEsc),"undefined"!=typeof oData.aaSearchCols)for(var i=0;i<oData.aaSearchCols.length;i++)oSettings.aoPreSearchCols[i]={sSearch:oData.aaSearchCols[i][0],bEscapeRegex:oData.aaSearchCols[i][1]};/* Column visibility state - added in 1.5.0 beta 10 */
if("undefined"!=typeof oData.abVisCols)for(/* Pass back visibiliy settings to the init handler, but to do not here override
					 * the init object that the user might have passed in
					 */
oInit.saved_aoColumns=[],i=0;i<oData.abVisCols.length;i++)oInit.saved_aoColumns[i]={},oInit.saved_aoColumns[i].bVisible=oData.abVisCols[i]}}}/*
		 * Function: _fnCreateCookie
		 * Purpose:  Create a new cookie with a value to store the state of a table
		 * Returns:  -
		 * Inputs:   string:sName - name of the cookie to create
		 *           string:sValue - the value the cookie should take
		 *           int:iSecs - duration of the cookie
		 */
function _fnCreateCookie(e,a,t){var n=new Date;n.setTime(n.getTime()+1e3*t),/* 
			 * Shocking but true - it would appear IE has major issues with having the path being
			 * set to anything but root. We need the cookie to be available based on the path, so we
			 * have to append the pathname to the cookie name. Appalling.
			 */
e+="_"+window.location.pathname.replace(/[\/:]/g,"").toLowerCase(),document.cookie=e+"="+encodeURIComponent(a)+"; expires="+n.toGMTString()+"; path=/"}/*
		 * Function: _fnReadCookie
		 * Purpose:  Read an old cookie to get a cookie with an old table state
		 * Returns:  string: - contents of the cookie - or null if no cookie with that name found
		 * Inputs:   string:sName - name of the cookie to read
		 */
function _fnReadCookie(e){for(var a=e+"_"+window.location.pathname.replace(/[\/:]/g,"").toLowerCase()+"=",t=document.cookie.split(";"),n=0;n<t.length;n++){for(var o=t[n];" "==o.charAt(0);)o=o.substring(1,o.length);if(0===o.indexOf(a))return decodeURIComponent(o.substring(a.length,o.length))}return null}/*
		 * Function: _fnGetUniqueThs
		 * Purpose:  Get an array of unique th elements, one for each column
		 * Returns:  array node:aReturn - list of unique ths
		 * Inputs:   node:nThead - The thead element for the table
		 */
function _fnGetUniqueThs(e){var a=e.getElementsByTagName("tr");/* Nice simple case */
if(1==a.length)return a[0].getElementsByTagName("th");/* Otherwise we need to figure out the layout array to get the nodes */
var t,n,o,s,i,r,l=[],u=[],f=2,d=3,p=4,g=function(e,a,t){for(;"undefined"!=typeof e[a][t];)t++;return t},c=function(e){"undefined"==typeof l[e]&&(l[e]=[])};/* Calculate a layout array */
for(t=0,s=a.length;t<s;t++){c(t);var h=0,_=[];for(n=0,i=a[t].childNodes.length;n<i;n++)"TD"!=a[t].childNodes[n].nodeName&&"TH"!=a[t].childNodes[n].nodeName||_.push(a[t].childNodes[n]);for(n=0,i=_.length;n<i;n++){var S=1*_[n].getAttribute("colspan"),D=1*_[n].getAttribute("rowspan");if(S&&0!==S&&1!==S){for(r=g(l,t,h),o=0;o<S;o++)l[t][r+o]=d;h+=S}else{if(r=g(l,t,h),l[t][r]="TD"==_[n].nodeName?p:_[n],D||0===D||1===D)for(o=1;o<D;o++)c(t+o),l[t+o][r]=f;h++}}}/* Convert the layout array into a node array
			 * Note the use of aLayout[0] in the outloop, we want the outer loop to occur the same
			 * number of times as there are columns. Unusual having nested loops this way around
			 * but is what we need here.
			 */
for(t=0,s=l[0].length;t<s;t++)for(n=0,i=l.length;n<i;n++)"object"==typeof l[n][t]&&u.push(l[n][t]);return u}/*
		 * Function: _fnMap
		 * Purpose:  See if a property is defined on one object, if so assign it to the other object
		 * Returns:  - (done by reference)
		 * Inputs:   object:oRet - target object
		 *           object:oSrc - source object
		 *           string:sName - property
		 *           string:sMappedName - name to map too - optional, sName used if not given
		 */
function _fnMap(e,a,t,n){"undefined"==typeof n&&(n=t),"undefined"!=typeof a[t]&&(e[n]=a[t])}/*
		 * Variable: oApi
		 * Purpose:  Container for publicly exposed 'private' functions
		 * Scope:    jQuery.dataTable
		 */
this.oApi={},/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - API functions
		 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
		 * Function: fnDraw
		 * Purpose:  Redraw the table
		 * Returns:  -
		 * Inputs:   bool:bComplete - Refilter and resort (if enabled) the table before the draw.
		 *             Optional: default - true
		 */
this.fnDraw=function(e){var a=_fnSettingsFromNode(this[_oExt.iApiIndex]);"undefined"!=typeof e&&e===!1?(_fnCalculateEnd(a),_fnDraw(a)):_fnReDraw(a)},/*
		 * Function: fnFilter
		 * Purpose:  Filter the input based on data
		 * Returns:  -
		 * Inputs:   string:sInput - string to filter the table on
		 *           int:iColumn - optional - column to limit filtering to
		 *           bool:bEscapeRegex - optional - escape regex characters or not - default true
		 */
this.fnFilter=function(e,a,t){var n=_fnSettingsFromNode(this[_oExt.iApiIndex]);"undefined"==typeof t&&(t=!0),"undefined"==typeof a||null===a?/* Global filter */
_fnFilterComplete(n,{sSearch:e,bEscapeRegex:t},1):(/* Single column filter */
n.aoPreSearchCols[a].sSearch=e,n.aoPreSearchCols[a].bEscapeRegex=t,_fnFilterComplete(n,n.oPreviousSearch,1))},/*
		 * Function: fnSettings
		 * Purpose:  Get the settings for a particular table for extern. manipulation
		 * Returns:  -
		 * Inputs:   -
		 */
this.fnSettings=function(e){return _fnSettingsFromNode(this[_oExt.iApiIndex])},/*
		 * Function: fnVersionCheck
		 * Purpose:  Check a version string against this version of DataTables. Useful for plug-ins
		 * Returns:  bool:true -this version of DataTables is greater or equal to the required version
		 *                false -this version of DataTales is not suitable
		 * Inputs:   string:sVersion - the version to check against. May be in the following formats:
		 *             "a", "a.b" or "a.b.c"
		 * Notes:    This function will only check the first three parts of a version string. It is
		 *   assumed that beta and dev versions will meet the requirements. This might change in future
		 */
this.fnVersionCheck=function(e){for(var a=function(e,a){for(;e.length<a;)e+="0";return e},t=_oExt.sVersion.split("."),n=e.split("."),o="",s="",i=0,r=n.length;i<r;i++)o+=a(t[i],3),s+=a(n[i],3);return parseInt(o,10)>=parseInt(s,10)},/*
		 * Function: fnSort
		 * Purpose:  Sort the table by a particular row
		 * Returns:  -
		 * Inputs:   int:iCol - the data index to sort on. Note that this will
		 *   not match the 'display index' if you have hidden data entries
		 */
this.fnSort=function(e){var a=_fnSettingsFromNode(this[_oExt.iApiIndex]);a.aaSorting=e,_fnSort(a)},/*
		 * Function: fnSortListener
		 * Purpose:  Attach a sort listener to an element for a given column
		 * Returns:  -
		 * Inputs:   node:nNode - the element to attach the sort listener to
		 *           int:iColumn - the column that a click on this node will sort on
		 *           function:fnCallback - callback function when sort is run - optional
		 */
this.fnSortListener=function(e,a,t){_fnSortAttachListener(_fnSettingsFromNode(this[_oExt.iApiIndex]),e,a,t)},/*
		 * Function: fnAddData
		 * Purpose:  Add new row(s) into the table
		 * Returns:  array int: array of indexes (aoData) which have been added (zero length on error)
		 * Inputs:   array:mData - the data to be added. The length must match
		 *               the original data from the DOM
		 *             or
		 *             array array:mData - 2D array of data to be added
		 *           bool:bRedraw - redraw the table or not - default true
		 * Notes:    Warning - the refilter here will cause the table to redraw
		 *             starting at zero
		 * Notes:    Thanks to Yekimov Denis for contributing the basis for this function!
		 */
this.fnAddData=function(e,a){if(0===e.length)return[];var t,n=[],o=_fnSettingsFromNode(this[_oExt.iApiIndex]);/* Check if we want to add multiple rows or not */
if("object"==typeof e[0])for(var s=0;s<e.length;s++){if(t=_fnAddData(o,e[s]),t==-1)return n;n.push(t)}else{if(t=_fnAddData(o,e),t==-1)return n;n.push(t)}/* Rebuild the search */
return o.aiDisplay=o.aiDisplayMaster.slice(),_fnBuildSearchArray(o,1),("undefined"==typeof a||a)&&_fnReDraw(o),n},/*
		 * Function: fnDeleteRow
		 * Purpose:  Remove a row for the table
		 * Returns:  array:aReturn - the row that was deleted
		 * Inputs:   mixed:mTarget - 
		 *             int: - index of aoData to be deleted, or
		 *             node(TR): - TR element you want to delete
		 *           function:fnCallBack - callback function - default null
		 *           bool:bNullRow - remove the row information from aoData by setting the value to
		 *             null - default false
		 * Notes:    This function requires a little explanation - we don't actually delete the data
		 *   from aoData - rather we remove it's references from aiDisplayMastr and aiDisplay. This
		 *   in effect prevnts DataTables from drawing it (hence deleting it) - it could be restored
		 *   if you really wanted. The reason for this is that actually removing the aoData object
		 *   would mess up all the subsequent indexes in the display arrays (they could be ajusted - 
		 *   but this appears to do what is required).
		 */
this.fnDeleteRow=function(e,a,t){/* Find settings from table node */
var n,o,s=_fnSettingsFromNode(this[_oExt.iApiIndex]);/* Delete from the display master */
for(o="object"==typeof e?_fnNodeToDataIndex(s,e):e,n=0;n<s.aiDisplayMaster.length;n++)if(s.aiDisplayMaster[n]==o){s.aiDisplayMaster.splice(n,1);break}/* Delete from the current display index */
for(n=0;n<s.aiDisplay.length;n++)if(s.aiDisplay[n]==o){s.aiDisplay.splice(n,1);break}/* Rebuild the search */
_fnBuildSearchArray(s,1),/* If there is a user callback function - call it */
"function"==typeof a&&a.call(this),/* Check for an 'overflow' they case for dislaying the table */
s._iDisplayStart>=s.aiDisplay.length&&(s._iDisplayStart-=s._iDisplayLength,s._iDisplayStart<0&&(s._iDisplayStart=0)),_fnCalculateEnd(s),_fnDraw(s);/* Return the data array from this row */
var i=s.aoData[o]._aData.slice();return"undefined"!=typeof t&&t===!0&&(s.aoData[o]=null),i},/*
		 * Function: fnClearTable
		 * Purpose:  Quickly and simply clear a table
		 * Returns:  -
		 * Inputs:   bool:bRedraw - redraw the table or not - default true
		 * Notes:    Thanks to Yekimov Denis for contributing the basis for this function!
		 */
this.fnClearTable=function(e){/* Find settings from table node */
var a=_fnSettingsFromNode(this[_oExt.iApiIndex]);_fnClearTable(a),("undefined"==typeof e||e)&&_fnDraw(a)},/*
		 * Function: fnOpen
		 * Purpose:  Open a display row (append a row after the row in question)
		 * Returns:  node:nNewRow - the row opened
		 * Inputs:   node:nTr - the table row to 'open'
		 *           string:sHtml - the HTML to put into the row
		 *           string:sClass - class to give the new cell
		 */
this.fnOpen=function(e,a,t){/* Find settings from table node */
var n=_fnSettingsFromNode(this[_oExt.iApiIndex]);/* the old open one if there is one */
this.fnClose(e);var o=document.createElement("tr"),s=document.createElement("td");o.appendChild(s),s.className=t,s.colSpan=_fnVisbleColumns(n),s.innerHTML=a;/* If the nTr isn't on the page at the moment - then we don't insert at the moment */
var i=$("tbody tr",n.nTable);/* No point in storing the row if using server-side processing since the nParent will be
			 * nuked on a re-draw anyway
			 */
return $.inArray(e,i)!=-1&&$(o).insertAfter(e),n.oFeatures.bServerSide||n.aoOpenRows.push({nTr:o,nParent:e}),o},/*
		 * Function: fnClose
		 * Purpose:  Close a display row
		 * Returns:  int: 0 (success) or 1 (failed)
		 * Inputs:   node:nTr - the table row to 'close'
		 */
this.fnClose=function(e){for(var a=_fnSettingsFromNode(this[_oExt.iApiIndex]),t=0;t<a.aoOpenRows.length;t++)if(a.aoOpenRows[t].nParent==e){var n=a.aoOpenRows[t].nTr.parentNode;/* Remove it if it is currently on display */
return n&&n.removeChild(a.aoOpenRows[t].nTr),a.aoOpenRows.splice(t,1),0}return 1},/*
		 * Function: fnGetData
		 * Purpose:  Return an array with the data which is used to make up the table
		 * Returns:  array array string: 2d data array ([row][column]) or array string: 1d data array
		 *           or
		 *           array string (if iRow specified)
		 * Inputs:   mixed:mRow - optional - if not present, then the full 2D array for the table 
		 *             if given then:
		 *               int: - return 1D array for aoData entry of this index
		 *               node(TR): - return 1D array for this TR element
		 * Inputs:   int:iRow - optional - if present then the array returned will be the data for
		 *             the row with the index 'iRow'
		 */
this.fnGetData=function(e){var a=_fnSettingsFromNode(this[_oExt.iApiIndex]);if("undefined"!=typeof e){var t="object"==typeof e?_fnNodeToDataIndex(a,e):e;return a.aoData[t]._aData}return _fnGetDataMaster(a)},/*
		 * Function: fnGetNodes
		 * Purpose:  Return an array with the TR nodes used for drawing the table
		 * Returns:  array node: TR elements
		 *           or
		 *           node (if iRow specified)
		 * Inputs:   int:iRow - optional - if present then the array returned will be the node for
		 *             the row with the index 'iRow'
		 */
this.fnGetNodes=function(e){var a=_fnSettingsFromNode(this[_oExt.iApiIndex]);return"undefined"!=typeof e?a.aoData[e].nTr:_fnGetTrNodes(a)},/*
		 * Function: fnGetPosition
		 * Purpose:  Get the array indexes of a particular cell from it's DOM element
		 * Returns:  int: - row index, or array[ int, int, int ]: - row index, column index (visible)
		 *             and column index including hidden columns
		 * Inputs:   node:nNode - this can either be a TR or a TD in the table, the return is
		 *             dependent on this input
		 */
this.fnGetPosition=function(e){var a=_fnSettingsFromNode(this[_oExt.iApiIndex]);if("TR"==e.nodeName)return _fnNodeToDataIndex(a,e);if("TD"==e.nodeName)for(var t=_fnNodeToDataIndex(a,e.parentNode),n=0,o=0;o<a.aoColumns.length;o++)if(a.aoColumns[o].bVisible){if(a.aoData[t].nTr.getElementsByTagName("td")[o-n]==e)return[t,o-n,o]}else n++;return null},/*
		 * Function: fnUpdate
		 * Purpose:  Update a table cell or row
		 * Returns:  int: 0 okay, 1 error
		 * Inputs:   array string 'or' string:mData - data to update the cell/row with
		 *           mixed:mRow - 
		 *             int: - index of aoData to be updated, or
		 *             node(TR): - TR element you want to update
		 *           int:iColumn - the column to update - optional (not used of mData is 2D)
		 *           bool:bRedraw - redraw the table or not - default true
		 */
this.fnUpdate=function(e,a,t,n){var o,s,i=_fnSettingsFromNode(this[_oExt.iApiIndex]),r="object"==typeof a?_fnNodeToDataIndex(i,a):a;if("object"!=typeof e)s=e,i.aoData[r]._aData[t]=s,null!==i.aoColumns[t].fnRender&&(s=i.aoColumns[t].fnRender({iDataRow:r,iDataColumn:t,aData:i.aoData[r]._aData,oSettings:i}),i.aoColumns[t].bUseRendered&&(i.aoData[r]._aData[t]=s)),o=_fnColumnIndexToVisible(i,t),null!==o&&(i.aoData[r].nTr.getElementsByTagName("td")[o].innerHTML=s);else{if(e.length!=i.aoColumns.length)return alert("DataTables warning: An array passed to fnUpdate must have the same number of columns as the table in question - in this case "+i.aoColumns.length),1;for(var l=0;l<e.length;l++)s=e[l],i.aoData[r]._aData[l]=s,null!==i.aoColumns[l].fnRender&&(s=i.aoColumns[l].fnRender({iDataRow:r,iDataColumn:l,aData:i.aoData[r]._aData,oSettings:i}),i.aoColumns[l].bUseRendered&&(i.aoData[r]._aData[l]=s)),o=_fnColumnIndexToVisible(i,l),null!==o&&(i.aoData[r].nTr.getElementsByTagName("td")[o].innerHTML=s)}/* Update the search array */
/* Redraw the table */
return _fnBuildSearchArray(i,1),"undefined"!=typeof n&&n&&_fnReDraw(i),0},/*
		 * Function: fnShowColoumn
		 * Purpose:  Show a particular column
		 * Returns:  -
		 * Inputs:   int:iCol - the column whose display should be changed
		 *           bool:bShow - show (true) or hide (false) the column
		 */
this.fnSetColumnVis=function(e,a){var t,n,o,s,i=_fnSettingsFromNode(this[_oExt.iApiIndex]),r=i.aoColumns.length;/* No point in doing anything if we are requesting what is already true */
if(i.aoColumns[e].bVisible!=a){var l=$("thead:eq(0)>tr",i.nTable)[0],u=$("tfoot:eq(0)>tr",i.nTable)[0],f=[],d=[];for(t=0;t<r;t++)f.push(i.aoColumns[t].nTh),d.push(i.aoColumns[t].nTf);/* Show the column */
if(a){var p=0;for(t=0;t<e;t++)i.aoColumns[t].bVisible&&p++;/* Need to decide if we should use appendChild or insertBefore */
if(p>=_fnVisbleColumns(i))for(l.appendChild(f[e]),u&&u.appendChild(d[e]),t=0,n=i.aoData.length;t<n;t++)o=i.aoData[t]._anHidden[e],i.aoData[t].nTr.appendChild(o);else{/* Which coloumn should we be inserting before? */
var g;for(t=e;t<r&&(g=_fnColumnIndexToVisible(i,t),null===g);t++);for(l.insertBefore(f[e],l.getElementsByTagName("th")[g]),u&&u.insertBefore(d[e],u.getElementsByTagName("th")[g]),s=_fnGetTdNodes(i),t=0,n=i.aoData.length;t<n;t++)o=i.aoData[t]._anHidden[e],i.aoData[t].nTr.insertBefore(o,$(">td:eq("+g+")",i.aoData[t].nTr)[0])}i.aoColumns[e].bVisible=!0}else{for(/* Remove a column from display */
l.removeChild(f[e]),u&&u.removeChild(d[e]),s=_fnGetTdNodes(i),t=0,n=i.aoData.length;t<n;t++)o=s[t*i.aoColumns.length+e],i.aoData[t]._anHidden[e]=o,o.parentNode.removeChild(o);i.aoColumns[e].bVisible=!1}/* If there are any 'open' rows, then we need to alter the colspan for this col change */
for(t=0,n=i.aoOpenRows.length;t<n;t++)i.aoOpenRows[t].nTr.colSpan=_fnVisbleColumns(i);/* Since there is no redraw done here, we need to save the state manually */
_fnSaveState(i)}},/*
		 * Function: fnPageChange
		 * Purpose:  Change the pagination
		 * Returns:  -
		 * Inputs:   string:sAction - paging action to take: "first", "previous", "next" or "last"
		 *           bool:bRedraw - redraw the table or not - optional - default true
		 */
this.fnPageChange=function(e,a){var t=_fnSettingsFromNode(this[_oExt.iApiIndex]);_fnPageChange(t,e),_fnCalculateEnd(t),("undefined"==typeof a||a)&&_fnDraw(t)};for(var sFunc in _oExt.oApi)sFunc&&(/*
				 * Function: anon
				 * Purpose:  Wrap the plug-in API functions in order to provide the settings as 1st arg 
				 *   and execute in this scope
				 * Returns:  -
				 * Inputs:   -
				 */
this[sFunc]=_fnExternApiFunc(sFunc));/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - API
		 * 
		 * I'm not overly happy with this solution - I'd much rather that there was a way of getting
		 * a list of all the private functions and do what we need to dynamically - but that doesn't
		 * appear to be possible. Bonkers. A better solution would be to provide a 'bind' type object
		 * To do - bind type method in DTs 2.x.
		 */
this.oApi._fnInitalise=_fnInitalise,this.oApi._fnLanguageProcess=_fnLanguageProcess,this.oApi._fnAddColumn=_fnAddColumn,this.oApi._fnAddData=_fnAddData,this.oApi._fnGatherData=_fnGatherData,this.oApi._fnDrawHead=_fnDrawHead,this.oApi._fnDraw=_fnDraw,this.oApi._fnAjaxUpdate=_fnAjaxUpdate,this.oApi._fnAddOptionsHtml=_fnAddOptionsHtml,this.oApi._fnFeatureHtmlFilter=_fnFeatureHtmlFilter,this.oApi._fnFeatureHtmlInfo=_fnFeatureHtmlInfo,this.oApi._fnFeatureHtmlPaginate=_fnFeatureHtmlPaginate,this.oApi._fnPageChange=_fnPageChange,this.oApi._fnFeatureHtmlLength=_fnFeatureHtmlLength,this.oApi._fnFeatureHtmlProcessing=_fnFeatureHtmlProcessing,this.oApi._fnProcessingDisplay=_fnProcessingDisplay,this.oApi._fnFilterComplete=_fnFilterComplete,this.oApi._fnFilterColumn=_fnFilterColumn,this.oApi._fnFilter=_fnFilter,this.oApi._fnSortingClasses=_fnSortingClasses,this.oApi._fnVisibleToColumnIndex=_fnVisibleToColumnIndex,this.oApi._fnColumnIndexToVisible=_fnColumnIndexToVisible,this.oApi._fnNodeToDataIndex=_fnNodeToDataIndex,this.oApi._fnVisbleColumns=_fnVisbleColumns,this.oApi._fnBuildSearchArray=_fnBuildSearchArray,this.oApi._fnDataToSearch=_fnDataToSearch,this.oApi._fnCalculateEnd=_fnCalculateEnd,this.oApi._fnConvertToWidth=_fnConvertToWidth,this.oApi._fnCalculateColumnWidths=_fnCalculateColumnWidths,this.oApi._fnArrayCmp=_fnArrayCmp,this.oApi._fnDetectType=_fnDetectType,this.oApi._fnGetDataMaster=_fnGetDataMaster,this.oApi._fnGetTrNodes=_fnGetTrNodes,this.oApi._fnGetTdNodes=_fnGetTdNodes,this.oApi._fnEscapeRegex=_fnEscapeRegex,this.oApi._fnReOrderIndex=_fnReOrderIndex,this.oApi._fnColumnOrdering=_fnColumnOrdering,this.oApi._fnClearTable=_fnClearTable,this.oApi._fnSaveState=_fnSaveState,this.oApi._fnLoadState=_fnLoadState,this.oApi._fnCreateCookie=_fnCreateCookie,this.oApi._fnReadCookie=_fnReadCookie,this.oApi._fnGetUniqueThs=_fnGetUniqueThs,this.oApi._fnReDraw=_fnReDraw;/* Want to be able to reference "this" inside the this.each function */
var _that=this;/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		 * Section - Constructor
		 */
return this.each(function(){var e,a,t,n=0;/* Sanity check that we are not re-initialising a table - if we are, alert an error */
for(n=0,e=_aoSettings.length;n<e;n++)if(_aoSettings[n].nTable==this)return alert("DataTables warning: Unable to re-initialise DataTable. Please use the API to make any configuration changes required."),_aoSettings[n];/* Make a complete and independent copy of the settings object */
var o=new classSettings;_aoSettings.push(o);var s=!1,i=!1,r=this.getAttribute("id");null!==r?(o.sTableId=r,o.sInstance=r):o.sInstance=_oExt._oExternConfig.iNextUnique++,/* Set the table node */
o.nTable=this,/* Bind the API functions to the settings, so we can perform actions whenever oSettings is
			 * available
			 */
o.oApi=_that.oApi,/* Store the features that we have available */
"undefined"!=typeof oInit&&null!==oInit?(_fnMap(o.oFeatures,oInit,"bPaginate"),_fnMap(o.oFeatures,oInit,"bLengthChange"),_fnMap(o.oFeatures,oInit,"bFilter"),_fnMap(o.oFeatures,oInit,"bSort"),_fnMap(o.oFeatures,oInit,"bInfo"),_fnMap(o.oFeatures,oInit,"bProcessing"),_fnMap(o.oFeatures,oInit,"bAutoWidth"),_fnMap(o.oFeatures,oInit,"bSortClasses"),_fnMap(o.oFeatures,oInit,"bServerSide"),_fnMap(o,oInit,"asStripClasses"),_fnMap(o,oInit,"fnRowCallback"),_fnMap(o,oInit,"fnHeaderCallback"),_fnMap(o,oInit,"fnFooterCallback"),_fnMap(o,oInit,"fnInitComplete"),_fnMap(o,oInit,"fnServerData"),_fnMap(o,oInit,"aaSorting"),_fnMap(o,oInit,"aaSortingFixed"),_fnMap(o,oInit,"sPaginationType"),_fnMap(o,oInit,"sAjaxSource"),_fnMap(o,oInit,"iCookieDuration"),_fnMap(o,oInit,"sDom"),_fnMap(o,oInit,"oSearch","oPreviousSearch"),_fnMap(o,oInit,"aoSearchCols","aoPreSearchCols"),_fnMap(o,oInit,"iDisplayLength","_iDisplayLength"),_fnMap(o,oInit,"bJQueryUI","bJUI"),"function"==typeof oInit.fnDrawCallback&&/* Add user given callback function to array */
o.aoDrawCallback.push({fn:oInit.fnDrawCallback,sName:"user"}),o.oFeatures.bServerSide&&o.oFeatures.bSort&&o.oFeatures.bSortClasses&&/* Enable sort classes for server-side processing. Safe to do it here, since server-side
					 * processing must be enabled by the developer
					 */
o.aoDrawCallback.push({fn:_fnSortingClasses,sName:"server_side_sort_classes"}),"undefined"!=typeof oInit.bJQueryUI&&oInit.bJQueryUI&&(/* Use the JUI classes object for display. You could clone the oStdClasses object if 
					 * you want to have multiple tables with multiple independent classes 
					 */
o.oClasses=_oExt.oJUIClasses,"undefined"==typeof oInit.sDom&&(/* Set the DOM to use a layout suitable for jQuery UI's theming */
o.sDom='<"H"lfr>t<"F"ip>')),"undefined"!=typeof oInit.iDisplayStart&&"undefined"==typeof o.iInitDisplayStart&&(/* Display start point, taking into account the save saving */
o.iInitDisplayStart=oInit.iDisplayStart,o._iDisplayStart=oInit.iDisplayStart),/* Must be done after everything which can be overridden by a cookie! */
"undefined"!=typeof oInit.bStateSave&&(o.oFeatures.bStateSave=oInit.bStateSave,_fnLoadState(o,oInit),o.aoDrawCallback.push({fn:_fnSaveState,sName:"state_save"})),"undefined"!=typeof oInit.aaData&&(i=!0),/* Backwards compatability */
/* aoColumns / aoData - remove at some point... */
"undefined"!=typeof oInit&&"undefined"!=typeof oInit.aoData&&(oInit.aoColumns=oInit.aoData),/* Language definitions */
"undefined"!=typeof oInit.oLanguage&&("undefined"!=typeof oInit.oLanguage.sUrl&&""!==oInit.oLanguage.sUrl?(/* Get the language definitions from a file */
o.oLanguage.sUrl=oInit.oLanguage.sUrl,$.getJSON(o.oLanguage.sUrl,null,function(e){_fnLanguageProcess(o,e,!0)}),s=!0):_fnLanguageProcess(o,oInit.oLanguage,!1))):/* Create a dummy object for quick manipulation later on. */
oInit={},/* Add the strip classes now that we know which classes to apply - unless overruled */
"undefined"==typeof oInit.asStripClasses&&(o.asStripClasses.push(o.oClasses.sStripOdd),o.asStripClasses.push(o.oClasses.sStripEven));/* See if we should load columns automatically or use defined ones - a bit messy this... */
var l=this.getElementsByTagName("thead"),u=0===l.length?null:_fnGetUniqueThs(l[0]),f="undefined"!=typeof oInit.aoColumns;for(n=0,e=f?oInit.aoColumns.length:u.length;n<e;n++){var d=f?oInit.aoColumns[n]:null,p=u?u[n]:null;/* Check if we have column visibilty state to restore, and also that the length of the 
				 * state saved columns matches the currently know number of columns
				 */
"undefined"!=typeof oInit.saved_aoColumns&&oInit.saved_aoColumns.length==e&&(null===d&&(d={}),d.bVisible=oInit.saved_aoColumns[n].bVisible),_fnAddColumn(o,d,p)}/* Check the aaSorting array */
for(n=0,e=o.aaSorting.length;n<e;n++){var g=o.aoColumns[o.aaSorting[n][0]];/* Set the current sorting index based on aoColumns.asSorting */
for(/* Add a default sorting index */
"undefined"==typeof o.aaSorting[n][2]&&(o.aaSorting[n][2]=0),/* If aaSorting is not defined, then we use the first indicator in asSorting */
"undefined"==typeof oInit.aaSorting&&"undefined"==typeof o.saved_aaSorting&&(o.aaSorting[n][1]=g.asSorting[0]),a=0,t=g.asSorting.length;a<t;a++)if(o.aaSorting[n][1]==g.asSorting[a]){o.aaSorting[n][2]=a;break}}/* Check if there is data passing into the constructor */
if(/* Sanity check that there is a thead and tfoot. If not let's just create them */
0===this.getElementsByTagName("thead").length&&this.appendChild(document.createElement("thead")),0===this.getElementsByTagName("tbody").length&&this.appendChild(document.createElement("tbody")),i)for(n=0;n<oInit.aaData.length;n++)_fnAddData(o,oInit.aaData[n]);else/* Grab the data from the page */
_fnGatherData(o);/* Copy the data index array */
o.aiDisplay=o.aiDisplayMaster.slice(),/* Calculate sizes for columns */
o.oFeatures.bAutoWidth&&_fnCalculateColumnWidths(o),/* Initialisation complete - table can be drawn */
o.bInitialised=!0,/* Check if we need to initialise the table (it might not have been handed off to the
			 * language processor)
			 */
s===!1&&_fnInitalise(o)})}}(jQuery),
// EllisLab Defaults
$.extend(!0,$.fn.dataTableExt,{oStdClasses:{sSortAsc:"headerSortUp",sSortDesc:"headerSortDown"},oPagination:{iFullNumbersShowPages:3}});