$(document).ready(function () {

	var screenWidth, screenHeight, imageWidth, imageHeight, mapImage, markerImg, maptype;

	screenWidth = $(window).width();
	screenHeight = $(window).height();
	markerImg = "/images/uploads/main/mapMarker.png";

	SetMap(screenWidth);

	markerScale = (canvasDiv == "map1") ? 1920 / screenWidth : 640 / screenWidth;

	var stage = new createjs.Stage(canvasDiv);

	//background map
	var imageObj = new Image();
	imageObj.src = mapImage;

	//map markers
	var markers = [];
	var markerImage;

	imageObj.onload = function () {
		imageWidth = parseInt(this.width);
		imageHeight = parseInt(this.height);
		var backmap = new createjs.Bitmap(this);
		stage.addChild(backmap);

		var markerObj =  new Image();
		markerObj.src = markerImg;
		markerObj.onload = function () {
			CreateMarkers(markerObj);
		}

	}

	function SetMap(sw) {
		if (sw > 640) {
			mapImage = "/images/uploads/main/mapBmini.jpg";
			locationArray = locationFull;
			canvasDiv = "map1";
		} else {
			mapImage = "/images/uploads/main/mapMobile.jpg";
			locationArray = locationMobile;
			canvasDiv = "mapMobile";
		}

		$("#" + canvasDiv).css('display', 'block');

	} 

	function CreateMarkers(markerObj) {

		for (var i = 0; i < locationArray.length; i++) {
			var tempbitmap = new createjs.Bitmap(markerObj);
			tempbitmap.x = parseInt(locationArray[i].xpos) - 16 / markerScale;
			tempbitmap.y = parseInt(locationArray[i].ypos) - 23 / markerScale;
			tempbitmap.title = locationArray[i].title;
			tempbitmap.modalImage = locationArray[i].image;
			tempbitmap.text = locationArray[i].text;
			tempbitmap.scaleX = markerScale;
			tempbitmap.scaleY = markerScale;

			tempbitmap.addEventListener('click', (function(ev, ind) {

        		return function() {
        			
        			var i = ind;
        			var e = ev;
        			HandleClick(e, i);
    
       			}
    		
    		}(event, i)));

			stage.addChild(tempbitmap);
			markers[i] = tempbitmap; 
		}
		stage.update();
	}

	function HandleClick(event,index) { 
		$(".infobox img.infoImage").attr("src", "/images/uploads/main/" + locationArray[index].image);
		$(".infobox .textDiv h4").text(locationArray[index].title);
		$(".infobox .textDiv p").text(locationArray[index].text);

		setTimeout(function () { $(".infobox").show(); }, 500)
		
	}


	$(".infobox .closeButton, .mapfill").click(function (e) { console.log(e); $(".infobox").hide() })

})